/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summontrinketbuffs;

import java.awt.geom.Point2D;
import necesse.engine.localization.Localization;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobWasHitEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffManager;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.armorBuffs.trinketBuffs.TrinketBuff;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.toolItem.summonToolItem.SummonToolItem;
import necesse.inventory.item.trinketItem.TrinketItem;
import necesse.level.maps.Level;
import summonerexpansion.summonminions.TrinketMummyMagicMinion;
import summonerexpansion.summonminions.TrinketMummySummonMinion;

public class ScryingMagiciansCardBuff
extends TrinketBuff {
    static GameDamage damage = new GameDamage(DamageTypeRegistry.SUMMON, 50.0f);

    public void init(ActiveBuff buff, BuffEventSubscriber buffEventSubscriber) {
        buff.setModifier(BuffModifiers.MAX_SUMMONS, (Object)5);
        buff.setModifier(BuffModifiers.SUMMONS_SPEED, (Object)Float.valueOf(0.45f));
        buff.setModifier(BuffModifiers.SUMMON_ATTACK_SPEED, (Object)Float.valueOf(0.45f));
        buff.setModifier(BuffModifiers.MAGIC_ATTACK_SPEED, (Object)Float.valueOf(0.45f));
        buff.setModifier(BuffModifiers.COMBAT_MANA_REGEN, (Object)Float.valueOf(2.5f));
        buff.setModifier(BuffModifiers.MANA_USAGE, (Object)Float.valueOf(1.0f));
        buff.setModifier(BuffModifiers.MAX_MANA, (Object)Float.valueOf(0.6f));
        this.updateModifiers(buff);
    }

    public void clientTick(ActiveBuff buff) {
        this.updateModifiers(buff);
    }

    public void serverTick(ActiveBuff buff) {
        this.updateModifiers(buff);
    }

    private void updateModifiers(ActiveBuff buff) {
        float damageConversion = ((Float)buff.owner.buffManager.getModifier(BuffModifiers.SUMMON_DAMAGE)).floatValue();
        buff.setModifier(BuffModifiers.MAGIC_DAMAGE, (Object)Float.valueOf(damageConversion / 2.0f));
        buff.owner.buffManager.forceUpdateBuffs();
    }

    public void onHasAttacked(ActiveBuff buff, MobWasHitEvent event) {
        super.onHasAttacked(buff, event);
        if (!event.wasPrevented) {
            BuffManager targetBM;
            if (event.damageType == DamageTypeRegistry.MAGIC) {
                targetBM = event.target.buffManager;
                targetBM.addBuff(new ActiveBuff(BuffRegistry.getBuff((String)"mummymagicdebuff"), event.target, 10.0f, event.attacker), event.target.isServer());
                if (targetBM.getStacks(BuffRegistry.getBuff((String)"mummymagicdebuff")) >= 10) {
                    targetBM.removeBuff(BuffRegistry.getBuff((String)"mummymagicdebuff"), true);
                    ScryingMagiciansCardBuff.spawnMagicMummy(event.attacker.getAttackOwner());
                }
            }
            if (event.damageType == DamageTypeRegistry.SUMMON) {
                targetBM = event.target.buffManager;
                targetBM.addBuff(new ActiveBuff(BuffRegistry.getBuff((String)"mummysummondebuff"), event.target, 10.0f, event.attacker), event.target.isServer());
                if (targetBM.getStacks(BuffRegistry.getBuff((String)"mummysummondebuff")) >= 50) {
                    targetBM.removeBuff(BuffRegistry.getBuff((String)"mummysummondebuff"), true);
                    ScryingMagiciansCardBuff.spawnSummonMummy(event.attacker.getAttackOwner());
                }
            }
        }
    }

    public static void spawnMagicMummy(Mob owner) {
        if (owner != null && owner.isServer()) {
            int maxSummons = 2;
            TrinketMummyMagicMinion summonedMob = (TrinketMummyMagicMinion)MobRegistry.getMob((String)"mummymagicminion", (Level)owner.getLevel());
            ((ItemAttackerMob)owner).serverFollowersManager.addFollower("mummymagicdebuff", (Mob)summonedMob, FollowPosition.WALK_CLOSE, "summonedmob", 1.0f, p -> maxSummons, null, false);
            summonedMob.updateDamage(damage);
            Point2D.Float spawnPoint = SummonToolItem.findSpawnLocation((Mob)summonedMob, (Level)owner.getLevel(), (float)owner.x, (float)owner.y);
            owner.getLevel().entityManager.addMob((Mob)summonedMob, spawnPoint.x, spawnPoint.y);
        }
    }

    public static void spawnSummonMummy(Mob owner) {
        if (owner != null && owner.isServer()) {
            int maxSummons = 4;
            TrinketMummySummonMinion summonedMob = (TrinketMummySummonMinion)MobRegistry.getMob((String)"mummysummonminion", (Level)owner.getLevel());
            ((ItemAttackerMob)owner).serverFollowersManager.addFollower("mummysummondebuff", (Mob)summonedMob, FollowPosition.PYRAMID, "summonedmob", 1.0f, p -> maxSummons, null, false);
            summonedMob.updateDamage(damage);
            Point2D.Float spawnPoint = SummonToolItem.findSpawnLocation((Mob)summonedMob, (Level)owner.getLevel(), (float)owner.x, (float)owner.y);
            owner.getLevel().entityManager.addMob((Mob)summonedMob, spawnPoint.x, spawnPoint.y);
        }
    }

    public ListGameTooltips getTrinketTooltip(TrinketItem trinketItem, InventoryItem item, PlayerMob perspective) {
        ListGameTooltips tooltips = new ListGameTooltips();
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"scryingmagicianscardtip"));
        return tooltips;
    }
}

