/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summontrinketbuffs;

import java.util.function.BiConsumer;
import necesse.engine.localization.Localization;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.util.GameMath;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobWasHitEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.armorBuffs.trinketBuffs.TrinketBuff;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.FlyingAttackingFollowingMob;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.trinketItem.TrinketItem;
import necesse.level.maps.Level;

public class NecromancerArmorBuff
extends TrinketBuff {
    static GameDamage damage = new GameDamage(DamageTypeRegistry.SUMMON, 50.0f);

    public void init(ActiveBuff buff, BuffEventSubscriber eventSubscriber) {
        this.updateBuff(buff);
        this.isImportant = true;
        buff.setModifier(BuffModifiers.SUMMONS_TARGET_RANGE, (Object)Float.valueOf(0.2f));
        buff.setModifier(BuffModifiers.KNOCKBACK_INCOMING_MOD, (Object)Float.valueOf(0.0f));
        buff.setModifier(BuffModifiers.SUMMON_CRIT_CHANCE, (Object)Float.valueOf(0.15f));
        buff.setModifier(BuffModifiers.SUMMON_CRIT_DAMAGE, (Object)Float.valueOf(0.45f));
        buff.setModifier(BuffModifiers.ARMOR_PEN_FLAT, (Object)25);
        buff.setModifier(BuffModifiers.MAX_SUMMONS, (Object)1);
    }

    public void serverTick(ActiveBuff buff) {
        this.updateBuff(buff);
        this.updateActiveBuff(buff);
    }

    public void clientTick(ActiveBuff buff) {
        this.updateBuff(buff);
        this.updateActiveBuff(buff);
    }

    public void onHasAttacked(ActiveBuff buff, MobWasHitEvent event) {
        super.onHasAttacked(buff, event);
        if (!event.wasPrevented && event.damageType == DamageTypeRegistry.SUMMON) {
            event.target.buffManager.addBuff(new ActiveBuff(BuffRegistry.Debuffs.CHILLED, event.target, 10.0f, event.attacker), event.target.isServer());
        }
    }

    public void updateActiveBuff(ActiveBuff buff) {
        float healthPercent = buff.owner.getHealthPercent();
        if (healthPercent < 0.5f && buff.owner.buffManager.getBuffDurationLeftSeconds(BuffRegistry.BLOODSTONE_RING_REGEN_ACTIVE_BUFF) <= 1.0f) {
            ActiveBuff activeBuff = new ActiveBuff(BuffRegistry.BLOODSTONE_RING_REGEN_ACTIVE_BUFF, buff.owner, 4.0f, (Attacker)null);
            buff.owner.buffManager.addBuff(activeBuff, true);
        } else if (healthPercent >= 0.5f && buff.owner.buffManager.hasBuff(BuffRegistry.BLOODSTONE_RING_REGEN_ACTIVE_BUFF)) {
            buff.owner.buffManager.removeBuff(BuffRegistry.BLOODSTONE_RING_REGEN_ACTIVE_BUFF, true);
        }
    }

    private void updateBuff(ActiveBuff buff) {
        float current = ((Float)buff.getModifier(BuffModifiers.SUMMON_DAMAGE)).floatValue();
        float next = NecromancerArmorBuff.getAttackBonusPerc((float)buff.owner.getHealth() / (float)buff.owner.getMaxHealth(), 0.1f) * 0.5f;
        if (current != (next = GameMath.toDecimals((float)next, (int)2))) {
            buff.setModifier(BuffModifiers.SUMMON_DAMAGE, (Object)Float.valueOf(next));
            buff.forceManagerUpdate();
        }
    }

    public static float getAttackBonusPerc(float healthPercent, float offset) {
        if (offset != 0.0f) {
            healthPercent = (offset - healthPercent) / (offset - 1.0f);
        }
        healthPercent = GameMath.limit((float)healthPercent, (float)0.0f, (float)1.0f);
        return Math.abs(healthPercent - 1.0f);
    }

    public void onWasHit(ActiveBuff buff, MobWasHitEvent event) {
        super.onWasHit(buff, event);
        if (!event.wasPrevented && buff.owner.isServer()) {
            ItemAttackerMob attackerMob = (ItemAttackerMob)buff.owner;
            FlyingAttackingFollowingMob mob = (FlyingAttackingFollowingMob)MobRegistry.getMob((String)"horrorbatminion", (Level)buff.owner.getLevel());
            attackerMob.serverFollowersManager.addFollower("horrorcapebuff", (Mob)mob, FollowPosition.FLYING_CIRCLE, "summonedmob", 1.0f, 3, (BiConsumer)null, false);
            mob.updateDamage(damage);
            mob.getLevel().entityManager.addMob((Mob)mob, buff.owner.x, buff.owner.y);
        }
    }

    public ListGameTooltips getTrinketTooltip(TrinketItem trinketItem, InventoryItem item, PlayerMob perspective) {
        ListGameTooltips tooltips = new ListGameTooltips();
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"necromancerarmortip"));
        return tooltips;
    }
}

