/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summontrinketbuffs;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import necesse.engine.GameTileRange;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.MobRegistry;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.DeathMessageTable;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobObjectDamagedEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffManager;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.armorBuffs.trinketBuffs.TrinketBuff;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.toolItem.ToolDamageItem;
import necesse.inventory.item.trinketItem.TrinketItem;
import necesse.level.gameObject.GameObject;
import necesse.level.maps.CollisionFilter;
import necesse.level.maps.Level;
import necesse.level.maps.LevelObjectHit;

public class MinersLanternBuff
extends TrinketBuff {
    public static GameTileRange tileRange = new GameTileRange(3, new Point[0]);

    public void init(ActiveBuff buff, BuffEventSubscriber eventSubscriber) {
        buff.setModifier(BuffModifiers.TOOL_DAMAGE, (Object)Float.valueOf(0.9f));
        buff.setModifier(BuffModifiers.MINING_RANGE, (Object)Float.valueOf(1.0f));
        buff.setModifier(BuffModifiers.MINING_SPEED, (Object)Float.valueOf(0.75f));
        buff.setModifier(BuffModifiers.BUILD_RANGE, (Object)Float.valueOf(2.0f));
        buff.setModifier(BuffModifiers.BUILDING_SPEED, (Object)Float.valueOf(0.5f));
        buff.setModifier(BuffModifiers.ITEM_PICKUP_RANGE, (Object)Float.valueOf(6.0f));
        this.updateModifiers(buff);
        eventSubscriber.subscribeEvent(MobObjectDamagedEvent.class, event -> {
            if (event.level.isServer() && event.totalDamage > 0 && event.attacker instanceof ToolDamageItem.ToolDamageItemAttacker) {
                int hitY;
                int centerTileX = event.result.getTileX();
                int centerTileY = event.result.getTileY();
                int hitX = event.result.showEffects ? event.result.mouseX : centerTileX * 32 + 16;
                int n = hitY = event.result.showEffects ? event.result.mouseY : centerTileY * 32 + 16;
                if (this.isValidObject(event.result.levelObject.object)) {
                    Point2D.Float hitDir = GameMath.normalize((float)((float)hitX - buff.owner.x), (float)((float)hitY - buff.owner.y));
                    float hitAngle = GameMath.getAngle((Point2D.Float)hitDir);
                    float angleOffset = 120.0f;
                    int arms = 2;
                    PlayerMob player = event.attacker.getFirstPlayerOwner();
                    ServerClient client = player != null && player.isServerClient() ? player.getServerClient() : null;
                    CollisionFilter collisionFilter = new CollisionFilter().customAdder((tp, rectangles) -> rectangles.add(new Rectangle(tp.tileX * 32, tp.tileY * 32, 32, 32))).addFilter(tp -> this.isValidObject(tp.object().object));
                    HashMap<Point, Integer> damageDealt = new HashMap<Point, Integer>();
                    damageDealt.put(new Point(centerTileX, centerTileY), event.totalDamage);
                    for (int i = 0; i < arms; ++i) {
                        float currentAngle = GameRandom.globalRandom.getFloatOffset(hitAngle, angleOffset / 2.0f);
                        float range = 64.0f;
                        Point2D.Float currentDir = GameMath.getAngleDir((float)currentAngle);
                        Line2D.Float line = new Line2D.Float(hitX, hitY, (float)hitX + currentDir.x * range, (float)hitY + currentDir.y * range);
                        ArrayList collisions = event.level.getCollisions((Shape)line, collisionFilter);
                        int damage = Math.max(1, (int)((float)event.totalDamage * GameRandom.globalRandom.getFloatBetween(0.3f, 1.0f)));
                        for (LevelObjectHit collision : collisions) {
                            int currentDamageDealt = damageDealt.getOrDefault(collision.getPoint(), 0);
                            if (currentDamageDealt >= event.totalDamage) continue;
                            int finalDamage = Math.min(event.totalDamage - currentDamageDealt, damage);
                            damageDealt.put(collision.getPoint(), currentDamageDealt + finalDamage);
                            event.level.entityManager.doObjectDamage(event.result.objectLayerID, collision.tileX, collision.tileY, finalDamage, event.toolTier, (Attacker)new MinersProstheticAttacker(buff.owner), client, event.result.showEffects, collision.tileX * 32 + 16, collision.tileY * 32 + 16);
                        }
                    }
                }
            }
        });
    }

    public boolean isValidObject(GameObject object) {
        return object.isRock;
    }

    public void clientTick(ActiveBuff buff) {
        this.updateModifiers(buff);
    }

    public void serverTick(ActiveBuff buff) {
        super.serverTick(buff);
        this.updateModifiers(buff);
        if (buff.owner.isItemAttacker) {
            ItemAttackerMob attackerMob = (ItemAttackerMob)buff.owner;
            float count = attackerMob.serverFollowersManager.getFollowerCount("willowisp");
            if (count <= 0.0f) {
                Level level = buff.owner.getLevel();
                Mob mob = MobRegistry.getMob((String)"willowisp", (Level)level);
                attackerMob.serverFollowersManager.addFollower("willowisp", mob, FollowPosition.WALK_CLOSE, "summonedwillothewisp", 1.0f, 1, null, false);
                Point spawnPoint = new Point(attackerMob.getX() + GameRandom.globalRandom.getIntBetween(-5, 5), attackerMob.getY() + GameRandom.globalRandom.getIntBetween(-5, 5));
                level.entityManager.addMob(mob, (float)spawnPoint.x, (float)spawnPoint.y);
            }
        }
    }

    public void onRemoved(ActiveBuff buff) {
        super.onRemoved(buff);
        BuffManager buffManager = buff.owner.buffManager;
        if (buff.owner.isServer() && buffManager.hasBuff("summonedwillothewisp")) {
            buffManager.removeBuff("summonedwillothewisp", true);
        }
    }

    private void updateModifiers(ActiveBuff buff) {
        float damageConversion = ((Float)buff.owner.buffManager.getModifier(BuffModifiers.TOOL_DAMAGE)).floatValue();
        buff.setModifier(BuffModifiers.SUMMON_DAMAGE, (Object)Float.valueOf(damageConversion - 1.0f));
        buff.owner.buffManager.forceUpdateBuffs();
    }

    public ListGameTooltips getTrinketTooltip(TrinketItem trinketItem, InventoryItem item, PlayerMob perspective) {
        ListGameTooltips tooltips = new ListGameTooltips();
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"minerslanterntip"));
        return tooltips;
    }

    public static class MinersProstheticAttacker
    implements Attacker {
        private final Mob owner;

        public MinersProstheticAttacker(Mob owner) {
            this.owner = owner;
        }

        public GameMessage getAttackerName() {
            return this.owner.getAttackerName();
        }

        public DeathMessageTable getDeathMessages() {
            return this.owner.getDeathMessages();
        }

        public Mob getFirstAttackOwner() {
            return this.owner;
        }
    }
}

