/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summontrinketbuffs;

import java.awt.geom.Point2D;
import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketBlinkScepter;
import necesse.engine.network.packet.PacketForceOfWind;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.BuffAddedEvent;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobWasHitEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffAbility;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.armorBuffs.trinketBuffs.TrinketBuff;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.level.maps.Level;

public class LittleAngelBuff
extends TrinketBuff
implements BuffAbility {
    public void init(ActiveBuff buff, BuffEventSubscriber eventSubscriber) {
        buff.setModifier(BuffModifiers.DASH_STACKS, (Object)3);
        buff.setModifier(BuffModifiers.DASH_COOLDOWN, (Object)Float.valueOf(-0.25f));
        buff.setModifier(BuffModifiers.MAX_SUMMONS, (Object)1);
        buff.setModifier(BuffModifiers.ARMOR_FLAT, (Object)10);
        buff.setModifier(BuffModifiers.SUMMON_CRIT_CHANCE, (Object)Float.valueOf(0.1f));
        buff.setModifier(BuffModifiers.SUMMON_DAMAGE, (Object)Float.valueOf(0.5f));
        buff.setModifier(BuffModifiers.MELEE_DAMAGE, (Object)Float.valueOf(-0.8f));
        buff.setModifier(BuffModifiers.RANGED_DAMAGE, (Object)Float.valueOf(-0.8f));
        buff.setModifier(BuffModifiers.MAGIC_DAMAGE, (Object)Float.valueOf(-0.8f));
        eventSubscriber.subscribeEvent(BuffAddedEvent.class, event -> {
            if (event.ab.buff == BuffRegistry.Debuffs.DASH_COOLDOWN && buff.owner.isServer()) {
                buff.owner.addResilience(5.0f);
                buff.owner.sendResiliencePacket(false);
            }
        });
    }

    public void onWasHit(ActiveBuff buff, MobWasHitEvent event) {
        if (buff.owner.buffManager.hasBuff(BuffRegistry.Debuffs.DASH_COOLDOWN)) {
            buff.owner.buffManager.removeBuff(BuffRegistry.Debuffs.DASH_COOLDOWN, false);
            if (buff.owner.isClient()) {
                for (int i = 0; i < 5; ++i) {
                    int angle = GameRandom.globalRandom.nextInt(360);
                    Point2D.Float dir = GameMath.getAngleDir((float)angle);
                    float range = GameRandom.globalRandom.getFloatBetween(25.0f, 40.0f);
                    float startX = dir.x * range;
                    float startY = 20.0f;
                    float endHeight = 29.0f;
                    float startHeight = endHeight + dir.y * range;
                    int lifeTime = GameRandom.globalRandom.getIntBetween(200, 500);
                    float speed = dir.x * range * 250.0f / (float)lifeTime;
                    buff.owner.getLevel().entityManager.addParticle((Entity)buff.owner, startX, startY, Particle.GType.IMPORTANT_COSMETIC).sprite(GameResources.puffParticles.sprite(GameRandom.globalRandom.nextInt(5), 0, 12)).sizeFades(24, 48).rotates().heightMoves(startHeight, endHeight).movesConstant(-speed, 0.0f).fadesAlphaTime(100, 50).lifeTime(lifeTime);
                }
                SoundManager.playSound((GameSound)GameResources.magicbolt4, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)buff.owner).volume(0.2f).pitch(GameRandom.globalRandom.getFloatBetween(1.9f, 2.1f)));
                SoundManager.playSound((GameSound)GameResources.magicbolt1, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)buff.owner).volume(0.2f).pitch(GameRandom.globalRandom.getFloatBetween(1.9f, 2.1f)));
            }
        }
    }

    public void runAbility(PlayerMob player, ActiveBuff buff, Packet content) {
        Level level = player.getLevel();
        int range = 224;
        Point2D.Float dir = PacketBlinkScepter.getMobDir((Mob)player);
        PacketBlinkScepter.applyToMob((Level)level, (Mob)player, (float)dir.x, (float)dir.y, (float)range);
        PacketForceOfWind.addCooldownStack((Mob)player, (float)5.0f, (boolean)false);
        if (level.isClient()) {
            SoundManager.playSound((GameSound)GameResources.swoosh2, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)player).volume(0.5f));
        }
    }

    public boolean canRunAbility(PlayerMob player, ActiveBuff buff, Packet content) {
        return !buff.owner.isRiding() && !PacketForceOfWind.isOnCooldown((Mob)buff.owner);
    }
}

