/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summontrinketbuffs;

import necesse.engine.localization.Localization;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.util.GameMath;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.armorBuffs.trinketBuffs.TrinketBuff;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.trinketItem.TrinketItem;

public class FrenzystoneRingBuff
extends TrinketBuff {
    public void init(ActiveBuff buff, BuffEventSubscriber eventSubscriber) {
        this.updateBuff(buff);
        this.isImportant = true;
    }

    public void serverTick(ActiveBuff buff) {
        this.updateBuff(buff);
        this.updateActiveBuff(buff);
    }

    public void clientTick(ActiveBuff buff) {
        this.updateBuff(buff);
        this.updateActiveBuff(buff);
    }

    public void updateActiveBuff(ActiveBuff buff) {
        float healthPercent = buff.owner.getHealthPercent();
        if (healthPercent < 0.5f && buff.owner.buffManager.getBuffDurationLeftSeconds(BuffRegistry.BLOODSTONE_RING_REGEN_ACTIVE_BUFF) <= 1.0f) {
            ActiveBuff activeBuff = new ActiveBuff(BuffRegistry.BLOODSTONE_RING_REGEN_ACTIVE_BUFF, buff.owner, 4.0f, (Attacker)null);
            buff.owner.buffManager.addBuff(activeBuff, true);
        } else if (healthPercent >= 0.5f && buff.owner.buffManager.hasBuff(BuffRegistry.BLOODSTONE_RING_REGEN_ACTIVE_BUFF)) {
            buff.owner.buffManager.removeBuff(BuffRegistry.BLOODSTONE_RING_REGEN_ACTIVE_BUFF, true);
        }
    }

    private void updateBuff(ActiveBuff buff) {
        float current = ((Float)buff.getModifier(BuffModifiers.SUMMON_DAMAGE)).floatValue();
        float next = FrenzystoneRingBuff.getAttackBonusPerc((float)buff.owner.getHealth() / (float)buff.owner.getMaxHealth(), 0.1f) * 0.5f;
        if (current != (next = GameMath.toDecimals((float)next, (int)2))) {
            buff.setModifier(BuffModifiers.SUMMON_DAMAGE, (Object)Float.valueOf(next));
            buff.forceManagerUpdate();
        }
    }

    public static float getAttackBonusPerc(float healthPercent, float offset) {
        if (offset != 0.0f) {
            healthPercent = (offset - healthPercent) / (offset - 1.0f);
        }
        healthPercent = GameMath.limit((float)healthPercent, (float)0.0f, (float)1.0f);
        return Math.abs(healthPercent - 1.0f);
    }

    public ListGameTooltips getTrinketTooltip(TrinketItem trinketItem, InventoryItem item, PlayerMob perspective) {
        ListGameTooltips tooltips = new ListGameTooltips();
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"frenzystoneringtip"));
        return tooltips;
    }
}

