/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summontrinketbuffs;

import java.awt.Color;
import java.util.concurrent.atomic.AtomicReference;
import necesse.engine.localization.Localization;
import necesse.engine.network.Packet;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffAbility;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.armorBuffs.trinketBuffs.TrinketBuff;
import necesse.entity.particle.Particle;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.trinketItem.TrinketItem;
import summonerexpansion.summonothers.DoomShroomEvent;

public class DoomShroomShieldBuff
extends TrinketBuff
implements BuffAbility {
    public void init(ActiveBuff buff, BuffEventSubscriber eventSubscriber) {
        buff.setModifier(BuffModifiers.SUMMON_DAMAGE, (Object)Float.valueOf(0.1f));
        buff.setModifier(BuffModifiers.TARGET_RANGE, (Object)Float.valueOf(0.5f));
    }

    public void runAbility(PlayerMob player, ActiveBuff buff, Packet content) {
        float cooldown = 10.0f;
        player.buffManager.addBuff(new ActiveBuff(BuffRegistry.getBuff((String)"doomshroomshieldcooldown"), (Mob)player, cooldown, null), false);
        player.getLevel().entityManager.addLevelEvent((LevelEvent)new DoomShroomEvent((Mob)player));
        player.buffManager.forceUpdateBuffs();
        float maxDist = 400.0f;
        int lifeTime = 1100;
        int minHeight = 0;
        int maxHeight = 30;
        int particles = 70;
        for (int i = 0; i < particles; ++i) {
            float height = (float)minHeight + (float)(maxHeight - minHeight) * (float)i / (float)particles;
            AtomicReference<Float> currentAngle = new AtomicReference<Float>(Float.valueOf(GameRandom.globalRandom.nextFloat() * 360.0f));
            float outDistance = GameRandom.globalRandom.getFloatBetween(60.0f, maxDist + 32.0f);
            boolean counterclockwise = GameRandom.globalRandom.nextBoolean();
            player.getLevel().entityManager.addParticle(player.x + GameRandom.globalRandom.getFloatBetween(0.0f, GameMath.sin((float)currentAngle.get().floatValue()) * maxDist), player.y + GameRandom.globalRandom.getFloatBetween(0.0f, GameMath.cos((float)currentAngle.get().floatValue()) * maxDist * 0.75f), Particle.GType.CRITICAL).color((Color)GameRandom.globalRandom.getOneOf((Object[])new Color[]{new Color(18, 18, 19), new Color(33, 33, 33), new Color(163, 39, 39), new Color(90, 33, 33)})).height(height).moves((pos, delta, cLifeTime, timeAlive, lifePercent) -> {
                float angle = currentAngle.accumulateAndGet(Float.valueOf(delta * 150.0f / 250.0f), Float::sum).floatValue();
                if (counterclockwise) {
                    angle = -angle;
                }
                float linearDown = GameMath.lerpExp((float)lifePercent, (float)0.525f, (float)0.0f, (float)1.0f);
                pos.x = player.x + outDistance * GameMath.sin((float)angle) * linearDown;
                pos.y = player.y + outDistance * GameMath.cos((float)angle) * linearDown * 0.75f;
            }).lifeTime(lifeTime).sizeFades(14, 18);
        }
    }

    public boolean canRunAbility(PlayerMob player, ActiveBuff buff, Packet content) {
        return !buff.owner.buffManager.hasBuff(BuffRegistry.getBuff((String)"doomshroomshieldcooldown"));
    }

    public ListGameTooltips getTrinketTooltip(TrinketItem trinketItem, InventoryItem item, PlayerMob perspective) {
        ListGameTooltips tooltips = new ListGameTooltips();
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"doomshroomshieldtip"));
        return tooltips;
    }
}

