/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summontrinketbuffs;

import java.awt.Color;
import java.awt.geom.Point2D;
import necesse.engine.localization.Localization;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobWasHitEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffManager;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.armorBuffs.trinketBuffs.TrinketBuff;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.DryadSpiritFollowingMob;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.gfx.gameTooltips.SpacerGameTooltip;
import necesse.gfx.gameTooltips.StringTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.toolItem.summonToolItem.SummonToolItem;
import necesse.inventory.item.trinketItem.TrinketItem;
import necesse.level.maps.Level;

public class BalancedSummonerBoardBuff
extends TrinketBuff {
    public void init(ActiveBuff buff, BuffEventSubscriber eventSubscriber) {
        buff.setModifier(BuffModifiers.SUMMON_DAMAGE, (Object)Float.valueOf(0.15f));
    }

    public void onHasAttacked(ActiveBuff buff, MobWasHitEvent event) {
        super.onHasAttacked(buff, event);
        if (!event.wasPrevented && event.damageType == DamageTypeRegistry.SUMMON) {
            event.target.buffManager.addBuff(new ActiveBuff(BuffRegistry.Debuffs.FROSTBURN, event.target, 10.0f, event.attacker), event.target.isServer());
            BuffManager targetBM = event.target.buffManager;
            targetBM.addBuff(new ActiveBuff(BuffRegistry.Debuffs.DRYAD_HAUNTED, event.target, 10.0f, event.attacker), event.target.isServer());
            if (targetBM.getStacks(BuffRegistry.Debuffs.DRYAD_HAUNTED) >= 10) {
                targetBM.removeBuff(BuffRegistry.Debuffs.DRYAD_HAUNTED, true);
                BalancedSummonerBoardBuff.spawnDryadSpirit(event.attacker.getAttackOwner());
            }
        }
    }

    public static void spawnDryadSpirit(Mob owner) {
        if (owner != null && owner.isServer()) {
            int maxSummons = 5;
            DryadSpiritFollowingMob summonedMob = (DryadSpiritFollowingMob)MobRegistry.getMob((String)"dryadspirit", (Level)owner.getLevel());
            ((ItemAttackerMob)owner).serverFollowersManager.addFollower("summonedmobtemp", (Mob)summonedMob, FollowPosition.FLYING_CIRCLE_FAST, "summonedmob", 1.0f, p -> maxSummons, null, false);
            Point2D.Float spawnPoint = SummonToolItem.findSpawnLocation((Mob)summonedMob, (Level)owner.getLevel(), (float)owner.x, (float)owner.y);
            owner.getLevel().entityManager.addMob((Mob)summonedMob, spawnPoint.x, spawnPoint.y);
        }
    }

    public void clientTick(ActiveBuff buff) {
        this.updateModifiers(buff);
    }

    public void serverTick(ActiveBuff buff) {
        this.updateModifiers(buff);
    }

    public void updateModifiers(ActiveBuff buff) {
        int uniqueFollowerCount;
        if (buff.owner instanceof PlayerMob && (uniqueFollowerCount = ((PlayerMob)buff.owner).serverFollowersManager.getUniqueFollowerCount()) > 0) {
            BuffManager buffManager = buff.owner.buffManager;
            if (buffManager.hasBuff(BuffRegistry.SUMMONERS_BESTIARY)) {
                buffManager.removeBuff(BuffRegistry.SUMMONERS_BESTIARY, true);
            }
            ActiveBuff ab = new ActiveBuff(BuffRegistry.SUMMONERS_BESTIARY, buff.owner, 1000, null);
            ab.setStacks(uniqueFollowerCount, 100, null);
            buffManager.addBuff(ab, true);
        }
    }

    public ListGameTooltips getTrinketTooltip(TrinketItem trinketItem, InventoryItem item, PlayerMob perspective) {
        ListGameTooltips tooltips = new ListGameTooltips();
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"balancedsummonerboardtip"));
        tooltips.add((Object)new SpacerGameTooltip(5));
        tooltips.add((Object)new StringTooltips(Localization.translate((String)"itemtooltip", (String)"dryadhauntweapontip", (String)"value", (Object)1), new Color(30, 177, 143), 400));
        return tooltips;
    }
}

