/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summontiles;

import java.awt.Color;
import java.awt.Point;
import necesse.engine.localization.Localization;
import necesse.engine.modifiers.ModifierValue;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.gfx.gameTexture.GameTextureSection;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.level.gameTile.TerrainSplatterTile;
import necesse.level.maps.Level;

public class EmpoweredEmerald
extends TerrainSplatterTile {
    private final GameRandom drawRandom;

    public EmpoweredEmerald() {
        super(false, "empoweredemerald");
        this.mapColor = new Color(0, 79, 99);
        this.canBeMined = true;
        this.drawRandom = new GameRandom();
        this.lightLevel = 50;
        this.tileHealth = 500;
        this.lightHue = 190.0f;
    }

    public void tick(Mob mob, Level level, int x, int y) {
        if (mob.isPlayer) {
            mob.buffManager.addBuff(new ActiveBuff(BuffRegistry.getBuff((String)"emeraldfloorbuff"), mob, 0.5f, (Attacker)mob), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getTerrainSprite(GameTextureSection terrainTexture, Level level, int tileX, int tileY) {
        int tile;
        GameRandom gameRandom = this.drawRandom;
        synchronized (gameRandom) {
            tile = this.drawRandom.seeded(EmpoweredEmerald.getTileSeed((int)tileX, (int)tileY)).nextInt(terrainTexture.getHeight() / 32);
        }
        return new Point(0, tile);
    }

    public int getTerrainPriority() {
        return 0;
    }

    public ModifierValue<Float> getSpeedModifier(Mob mob) {
        if (mob.isPlayer || mob.isHuman) {
            return new ModifierValue(BuffModifiers.SPEED, (Object)Float.valueOf(0.5f));
        }
        return super.getSpeedModifier(mob);
    }

    public ListGameTooltips getItemTooltips(InventoryItem item, PlayerMob perspective) {
        ListGameTooltips tooltips = super.getItemTooltips(item, perspective);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"empoweredemeraldtip"));
        return tooltips;
    }
}

