/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonprojs;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.particle.ParticleOption;
import necesse.entity.particle.fireworks.FireworksExplosion;
import necesse.entity.particle.fireworks.FireworksPath;
import necesse.entity.projectile.Projectile;
import necesse.entity.trails.Trail;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.Drawable;
import necesse.gfx.drawables.EntityDrawable;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.level.maps.Level;
import necesse.level.maps.LevelObjectHit;
import necesse.level.maps.light.GameLight;
import summonerexpansion.summonothers.MosquitoBowEvent;

public class MosquitoBowProj
extends Projectile {
    protected boolean isFallingProjectile;
    protected Point2D.Float targetPoints;
    protected GameDamage damage;
    protected float eventResilienceGain;

    public MosquitoBowProj() {
    }

    public MosquitoBowProj(Level level, Mob owner, float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, float eventResilienceGain, int knockback, Point2D.Float targetPoints, boolean isFallingProjectile) {
        this.setLevel(level);
        this.setOwner(owner);
        this.x = x;
        this.y = y;
        this.setTarget(targetX, targetY);
        this.speed = speed;
        this.distance = distance;
        this.setDamage(damage);
        this.damage = damage;
        this.eventResilienceGain = eventResilienceGain;
        this.knockback = knockback;
        this.targetPoints = targetPoints;
        this.isFallingProjectile = isFallingProjectile;
    }

    public void init() {
        super.init();
        this.height = 40.0f;
        this.piercing = 0;
        this.isSolid = false;
        this.heightBasedOnDistance = true;
        this.trailOffset = -25.0f;
        this.removeIfOutOfBounds = false;
        this.canBreakObjects = false;
        this.setWidth(6.0f, false);
    }

    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        writer.putNextBoolean(this.isFallingProjectile);
        if (this.targetPoints != null) {
            writer.putNextBoolean(true);
            writer.putNextFloat(this.targetPoints.x);
            writer.putNextFloat(this.targetPoints.y);
        } else {
            writer.putNextBoolean(false);
        }
    }

    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.isFallingProjectile = reader.getNextBoolean();
        this.targetPoints = reader.getNextBoolean() ? new Point2D.Float(reader.getNextFloat(), reader.getNextFloat()) : null;
    }

    public boolean canHit(Mob mob) {
        return false;
    }

    public void doHitLogic(Mob mob, LevelObjectHit object, float x, float y) {
        super.doHitLogic(mob, object, x, y);
        if (!this.isFallingProjectile) {
            MosquitoBowProj projectile = new MosquitoBowProj(this.getLevel(), this.getOwner(), this.targetPoints.x, this.targetPoints.y - (float)this.distance, this.targetPoints.x, this.targetPoints.y, this.speed, this.distance, this.damage, this.eventResilienceGain, this.knockback, null, true);
            projectile.getUniqueID(new GameRandom((long)this.getUniqueID()).nextSeeded(69));
            this.getLevel().entityManager.projectiles.addHidden((Entity)projectile);
        } else {
            float targetY;
            float targetX;
            if (mob != null) {
                targetX = mob.x;
                targetY = mob.y;
            } else {
                targetX = x;
                targetY = y;
            }
            int lifetime = 200;
            int range = 65;
            if (!this.isServer()) {
                SoundManager.playSound((GameSound)GameResources.bowhit, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this));
                SoundManager.playSound((GameSound)GameResources.slimeSplash3, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this));
                FireworksExplosion explosion = new FireworksExplosion(FireworksPath.sphere((float)GameRandom.globalRandom.getIntBetween(range - 10, range)));
                explosion.colorGetter = (particle, progress, random) -> ParticleOption.randomizeColor((float)54.0f, (float)0.0f, (float)0.2f, (float)0.0f, (float)0.0f, (float)0.0f);
                explosion.trailChance = 0.5f;
                explosion.particles = 40;
                explosion.lifetime = lifetime;
                explosion.popOptions = null;
                explosion.particleLightHue = 0.0f;
                explosion.explosionSound = null;
                explosion.spawnExplosion(this.getLevel(), targetX, targetY, this.getHeight(), GameRandom.globalRandom);
            }
            if (!this.isClient()) {
                Rectangle targetBox = new Rectangle((int)targetX - range, (int)targetY - range, range * 2, range * 2);
                this.streamTargets(this.getOwner(), targetBox).filter(m -> m.canBeHit((Attacker)this) && m.getDistance(targetX, targetY) <= (float)range).forEach(m -> m.isServerHit(this.getDamage(), m.x - x, m.y - y, (float)this.knockback, (Attacker)this));
            }
            this.getLevel().entityManager.addLevelEventHidden((LevelEvent)new MosquitoBowEvent(this.getOwner(), (int)x, (int)y, new GameRandom((long)this.getUniqueID()), this.getDamage(), this.eventResilienceGain));
        }
    }

    public Color getParticleColor() {
        return new Color(62, 59, 32);
    }

    public Trail getTrail() {
        Trail trail = new Trail((Projectile)this, this.getLevel(), new Color(87, 83, 44), 12.0f, 200, this.getHeight());
        trail.drawOnTop = true;
        return trail;
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, OrderableDrawables overlayList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        if (!this.removed()) {
            GameLight light = level.getLightLevel((Entity)this);
            int drawX = camera.getDrawX(this.x) - this.texture.getWidth() / 2;
            int drawY = camera.getDrawY(this.y);
            TextureDrawOptionsEnd options = this.texture.initDraw().light(light).rotate(this.getAngle(), this.texture.getWidth() / 2, 0).pos(drawX, drawY - (int)this.getHeight());
            topList.add((Drawable)new EntityDrawable((Entity)this, (TextureDrawOptions)options){
                final /* synthetic */ TextureDrawOptions val$options;
                {
                    this.val$options = textureDrawOptions;
                    super(arg0);
                }

                public void draw(TickManager tickManager) {
                    this.val$options.draw();
                }
            });
            this.addShadowDrawables(tileList, drawX, drawY, light, this.getAngle(), 0);
        }
    }
}

