/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonprojs;

import java.awt.Color;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.entity.Entity;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.projectile.Projectile;
import necesse.entity.trails.Trail;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.EntityDrawable;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.level.maps.Level;
import necesse.level.maps.LevelObjectHit;
import necesse.level.maps.light.GameLight;

public class IceWizardProj
extends Projectile {
    private long spawnTime;

    public IceWizardProj() {
    }

    public IceWizardProj(float x, float y, float targetX, float targetY, GameDamage damage, Mob owner) {
        this.x = x;
        this.y = y;
        this.setTarget(targetX, targetY);
        this.speed = 80.0f;
        this.setDamage(damage);
        this.setOwner(owner);
        this.setDistance(400);
    }

    public void init() {
        super.init();
        this.setWidth(8.0f);
        this.height = 18.0f;
        this.spawnTime = this.getWorldEntity().getTime();
        this.trailOffset = 0.0f;
    }

    public void doHitLogic(Mob mob, LevelObjectHit object, float x, float y) {
        super.doHitLogic(mob, object, x, y);
        if (this.isServer() && mob != null) {
            ActiveBuff ab = new ActiveBuff("icewizarddebuff", mob, 10.0f, (Attacker)this.getOwner());
            mob.addBuff(ab, true);
        }
    }

    public Trail getTrail() {
        return new Trail((Projectile)this, this.getLevel(), new Color(36, 174, 214), 14.0f, 250, this.getHeight());
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, OrderableDrawables overlayList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        if (!this.removed()) {
            GameLight light = level.getLightLevel((Entity)this);
            int drawX = camera.getDrawX(this.x) - this.texture.getWidth() / 2;
            int drawY = camera.getDrawY(this.y) - this.texture.getHeight() / 2;
            float rotate = this.getWorldEntity().getTime() - this.spawnTime;
            TextureDrawOptionsEnd options = this.texture.initDraw().light(light).rotate(rotate, this.texture.getWidth() / 2, this.texture.getHeight() / 2).pos(drawX, drawY - (int)this.getHeight());
            list.add((LevelSortedDrawable)new EntityDrawable((Entity)this, (TextureDrawOptions)options){
                final /* synthetic */ TextureDrawOptions val$options;
                {
                    this.val$options = textureDrawOptions;
                    super(arg0);
                }

                public void draw(TickManager tickManager) {
                    this.val$options.draw();
                }
            });
            this.addShadowDrawables(tileList, drawX, drawY, light, rotate, this.texture.getHeight() / 2);
        }
    }
}

