/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonprojs;

import java.awt.Color;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.journal.ImpaleIceJavelinsJournalChallenge;
import necesse.engine.journal.JournalChallenge;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.JournalChallengeRegistry;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.entity.Entity;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.particle.Particle;
import necesse.entity.particle.ProjectileHitStuckParticle;
import necesse.entity.projectile.Projectile;
import necesse.entity.trails.Trail;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.Drawable;
import necesse.gfx.drawables.EntityDrawable;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.level.maps.Level;
import necesse.level.maps.LevelObjectHit;
import necesse.level.maps.light.GameLight;

public class IceMinionJavelinProj
extends Projectile {
    public void init() {
        super.init();
        this.height = 18.0f;
        this.setWidth(4.0f);
        this.trailOffset = -50.0f;
        this.heightBasedOnDistance = true;
    }

    public Trail getTrail() {
        return new Trail((Projectile)this, this.getLevel(), new Color(69, 187, 224), 10.0f, 250, 18.0f);
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, OrderableDrawables overlayList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        if (!this.removed()) {
            GameLight light = level.getLightLevel((Entity)this);
            int drawX = camera.getDrawX(this.x) - 2;
            int drawY = camera.getDrawY(this.y) - 2;
            TextureDrawOptionsEnd options = this.texture.initDraw().light(light).rotate(this.getAngle() + 45.0f, 2, 2).pos(drawX, drawY - (int)this.getHeight());
            list.add((LevelSortedDrawable)new EntityDrawable((Entity)this, (TextureDrawOptions)options){
                final /* synthetic */ TextureDrawOptions val$options;
                {
                    this.val$options = textureDrawOptions;
                    super(arg0);
                }

                public void draw(TickManager tickManager) {
                    this.val$options.draw();
                }
            });
            this.addShadowDrawables(tileList, drawX, drawY, light, this.getAngle() + 45.0f, 2, 2);
        }
    }

    public void doHitLogic(Mob mob, LevelObjectHit object, float x, float y) {
        super.doHitLogic(mob, object, x, y);
        if (this.isServer() && mob != null) {
            Mob owner = this.getOwner();
            ActiveBuff ab = new ActiveBuff(BuffRegistry.getBuff((String)"frozenbookdebuff"), mob, 30.0f, (Attacker)this.getOwner());
            mob.addBuff(ab, true);
            if (owner.isPlayer && ((PlayerMob)owner).isServerClient()) {
                ServerClient serverClient = ((PlayerMob)owner).getServerClient();
                JournalChallenge challenge = JournalChallengeRegistry.getChallenge((int)JournalChallengeRegistry.IMPALE_FIVE_ICE_JAVELINS_ID);
                ((ImpaleIceJavelinsJournalChallenge)challenge).submitIceJavelinImpale(serverClient, mob);
            }
        }
        if (this.isClient() && this.traveledDistance < (float)this.distance) {
            final float height = this.getHeight();
            this.getLevel().entityManager.addParticle((Particle)new ProjectileHitStuckParticle(mob, this, x, y, mob == null ? 10.0f : 40.0f, 5000L){

                public void addDrawables(Mob target, float x, float y, float angle, List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
                    int fadeTime;
                    GameLight light = level.getLightLevel((Entity)this);
                    int drawX = camera.getDrawX(x) - 2;
                    int drawY = camera.getDrawY(y - height) - 2;
                    float alpha = 1.0f;
                    long lifeCycleTime = this.getLifeCycleTime();
                    if (lifeCycleTime >= this.lifeTime - (long)(fadeTime = 1000)) {
                        alpha = Math.abs((float)(lifeCycleTime - (this.lifeTime - (long)fadeTime)) / (float)fadeTime - 1.0f);
                    }
                    int cut = target == null ? 8 : 0;
                    TextureDrawOptionsEnd options = IceMinionJavelinProj.this.texture.initDraw().section(cut, IceMinionJavelinProj.this.texture.getWidth(), cut, IceMinionJavelinProj.this.texture.getHeight()).light(light).rotate(IceMinionJavelinProj.this.getAngle() + 45.0f, 2, 2).alpha(alpha).pos(drawX, drawY);
                    EntityDrawable drawable = new EntityDrawable((Entity)this, (TextureDrawOptions)options){
                        final /* synthetic */ TextureDrawOptions val$options;
                        {
                            this.val$options = textureDrawOptions;
                            super(arg0);
                        }

                        public void draw(TickManager tickManager) {
                            this.val$options.draw();
                        }
                    };
                    if (target != null) {
                        topList.add((Drawable)drawable);
                    } else {
                        list.add((LevelSortedDrawable)drawable);
                    }
                }
            }, Particle.GType.IMPORTANT_COSMETIC);
            if (this.isServer() && mob != null && this.modifier != null) {
                this.modifier.doHitLogic(mob, object, x, y);
            }
        }
    }

    protected void playHitSound(float x, float y) {
        SoundManager.playSound((GameSound)GameResources.tap, (SoundEffect)SoundEffect.effect((float)x, (float)y).volume(0.5f).pitch(0.8f));
    }
}

