/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonothers;

import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.ParticleTypeSwitcher;
import necesse.entity.levelEvent.explosionEvent.ExplosionEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.friendly.human.HumanMob;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.gameTexture.GameTextureSection;

public class SnowmanExplosionLevelEvent
extends ExplosionEvent
implements Attacker {
    protected ParticleTypeSwitcher explosionTypeSwitcher = new ParticleTypeSwitcher(new Particle.GType[]{Particle.GType.IMPORTANT_COSMETIC, Particle.GType.COSMETIC, Particle.GType.CRITICAL});

    public SnowmanExplosionLevelEvent() {
        this(0.0f, 0.0f, 100, new GameDamage(100.0f), false, 0, null);
    }

    public SnowmanExplosionLevelEvent(float x, float y, int range, GameDamage damage, boolean destructive, int toolTier, Mob owner) {
        super(x, y, range, damage, destructive, (float)toolTier, owner);
        this.knockback = 100;
    }

    protected boolean canHitMob(Mob target) {
        return target.isPlayer || target instanceof HumanMob || super.canHitMob(target);
    }

    protected GameDamage getTotalObjectDamage(float targetDistance) {
        return super.getTotalObjectDamage(targetDistance).modDamage(10.0f);
    }

    protected void playExplosionEffects() {
        SoundManager.playSound((GameSound)GameResources.pop, (SoundEffect)SoundEffect.effect((float)this.x, (float)this.y).volume(1.5f).pitch(0.5f));
        this.level.getClient().startCameraShake(this.x, this.y, 300, 40, 1.5f, 1.5f, true);
    }

    public float getParticleCount(float currentRange, float lastRange) {
        return super.getParticleCount(currentRange, lastRange) * 0.8f;
    }

    protected float getDistanceMod(float targetDistance) {
        return 1.0f;
    }

    public void spawnExplosionParticle(float x, float y, float dirX, float dirY, int lifeTime, float range) {
        GameTextureSection snowmanSprites = GameResources.smokePuff;
        int res = snowmanSprites.getHeight();
        int sprite = GameRandom.globalRandom.nextInt(snowmanSprites.getWidth() / res);
        if (GameRandom.globalRandom.getChance(0.5f)) {
            this.level.entityManager.addParticle(x + 4.0f, y - 10.0f, this.explosionTypeSwitcher.next()).sprite(snowmanSprites.sprite(sprite, 0, 32)).sizeFades(25, 40).movesConstant(dirX * 0.8f, dirY * 0.8f).height(10.0f).givesLight(75.0f, 0.5f).lifeTime(lifeTime);
        }
    }
}

