/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonothers;

import java.awt.geom.Point2D;
import java.util.function.BiConsumer;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.util.GameMath;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.attackHandler.GreatswordAttackHandler;
import necesse.entity.mobs.attackHandler.GreatswordChargeLevel;
import necesse.entity.mobs.itemAttacker.CheckSlotType;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.toolItem.summonToolItem.SummonToolItem;
import necesse.inventory.item.toolItem.swordToolItem.greatswordToolItem.GreatswordToolItem;
import necesse.level.maps.Level;
import summonerexpansion.summonminions.HorrorBullMinion;
import summonerexpansion.summonminions.HorrorWolfMinion;

public class HorrorScytheHandler
extends GreatswordAttackHandler {
    public HorrorScytheHandler(ItemAttackerMob attackerMob, ItemAttackSlot slot, InventoryItem item, GreatswordToolItem toolItem, int seed, int startX, int startY, GreatswordChargeLevel ... chargeLevels) {
        super(attackerMob, slot, item, toolItem, seed, startX, startY, chargeLevels);
    }

    public void onEndAttack(boolean bySelf) {
        super.onEndAttack(bySelf);
        Point2D.Float dir = GameMath.getAngleDir((float)this.currentAngle);
        switch (this.currentChargeLevel) {
            case 2: {
                this.strongSummonHorrorMob(dir);
            }
            case 1: {
                this.summonHorrorMob(dir);
            }
        }
    }

    private void strongSummonHorrorMob(Point2D.Float dir) {
        if (this.attackerMob.isServer()) {
            HorrorBullMinion mob = new HorrorBullMinion();
            this.attackerMob.serverFollowersManager.addFollower("horrorbullminion", (Mob)mob, FollowPosition.WALK_CLOSE, "summonedmob", 1.0f, 1, null, false);
            Point2D.Float spawnPoint = SummonToolItem.findSpawnLocation((Mob)mob, (Level)this.attackerMob.getLevel(), (float)this.attackerMob.x, (float)this.attackerMob.y);
            mob.updateDamage(this.toolItem.getAttackDamage(this.item).modFinalMultiplier(0.8f));
            mob.setEnchantment(this.toolItem.getEnchantment(this.item));
            if (!this.attackerMob.isPlayer) {
                mob.setRemoveWhenNotInInventory(ItemRegistry.getItem((String)"horrorscythe"), CheckSlotType.WEAPON);
            }
            mob.dx = dir.x * 300.0f;
            mob.dy = dir.y * 300.0f;
            this.attackerMob.getLevel().entityManager.addMob((Mob)mob, spawnPoint.x, spawnPoint.y);
        }
    }

    private void summonHorrorMob(Point2D.Float dir) {
        if (this.attackerMob.isServer()) {
            HorrorWolfMinion mob = new HorrorWolfMinion();
            this.attackerMob.serverFollowersManager.addFollower("horrorwolfminion", (Mob)mob, FollowPosition.WALK_CLOSE, "summonedmob", 1.0f, 3, (BiConsumer)null, false);
            Point2D.Float spawnPoint = SummonToolItem.findSpawnLocation((Mob)mob, (Level)this.attackerMob.getLevel(), (float)this.attackerMob.x, (float)this.attackerMob.y);
            mob.updateDamage(this.toolItem.getAttackDamage(this.item).modFinalMultiplier(0.2f));
            mob.setEnchantment(this.toolItem.getEnchantment(this.item));
            if (!this.attackerMob.isPlayer) {
                mob.setRemoveWhenNotInInventory(ItemRegistry.getItem((String)"horrorscythe"), CheckSlotType.WEAPON);
            }
            mob.dx = dir.x * 300.0f;
            mob.dy = dir.y * 300.0f;
            this.attackerMob.getLevel().entityManager.addMob((Mob)mob, spawnPoint.x, spawnPoint.y);
        }
    }
}

