/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonmounts;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.stream.Stream;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.localization.Localization;
import necesse.engine.modifiers.ModifierValue;
import necesse.engine.registries.MobRegistry;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.summon.summonFollowingMob.mountFollowingMob.MountFollowingMob;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class MouseSummonMount
extends MountFollowingMob {
    public static GameTexture texture_mask;

    public MouseSummonMount() {
        super(100);
        this.setSpeed(60.0f);
        this.setFriction(3.0f);
        this.collision = new Rectangle(-10, -7, 20, 14);
        this.hitBox = new Rectangle(-12, -14, 24, 24);
        this.selectBox = new Rectangle(-13, -18, 26, 28);
        this.swimMaskMove = 6;
        this.swimMaskOffset = 30;
        this.swimSinkOffset = 0;
    }

    protected String getInteractTip(PlayerMob perspective, boolean debug) {
        return this.isMounted() ? null : Localization.translate((String)"controls", (String)"usetip");
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 4; ++i) {
            this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), MobRegistry.Textures.mouse.body, 12, i, 16, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 16;
        int drawY = camera.getDrawY(y) - 22;
        int dir = this.getDir();
        Point sprite = this.getAnimSprite(x, y, dir);
        drawY += this.getBobbing(x, y);
        boolean mirror = (dir == 0 || dir == 2) && this.moveX < 0.0f;
        final MaskShaderOptions swimMask = this.getSwimMaskShaderOptions(this.inLiquidFloat(x, y));
        TextureDrawOptionsEnd options = MobRegistry.Textures.mouse.body.initDraw().sprite(sprite.x, sprite.y, 32).addMaskShader(swimMask).mirror(mirror, false).light(light).pos(drawX, drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this));
        list.add(new MobDrawable((DrawOptions)options){
            final /* synthetic */ DrawOptions val$options;
            {
                this.val$options = drawOptions;
            }

            public void draw(TickManager tickManager) {
                swimMask.use();
                this.val$options.draw();
                swimMask.stop();
            }
        });
        TextureDrawOptionsEnd shadow = MobRegistry.Textures.mouse.shadow.initDraw().sprite(0, dir, 32).mirror(mirror, false).light(light).pos(drawX, drawY);
        tileList.add(arg_0 -> MouseSummonMount.lambda$addDrawables$0((TextureDrawOptions)shadow, arg_0));
    }

    public Point getSpriteOffset(int spriteX, int spriteY) {
        Point point = new Point(0, 0);
        if (this.isAccelerating() && (spriteX == 1 || spriteX == 2)) {
            point.y = -5;
        }
        point.x += this.getRiderDrawXOffset();
        point.y += this.getRiderDrawYOffset() + 12;
        return point;
    }

    public int getRiderDrawYOffset() {
        PlayerMob player = (PlayerMob)this.getFollowingMob();
        if (player != null) {
            return -25;
        }
        return 0;
    }

    public GameTexture getRiderMask() {
        return texture_mask;
    }

    public int getRockSpeed() {
        return 7;
    }

    public Stream<ModifierValue<?>> getDefaultRiderModifiers() {
        return Stream.of(new ModifierValue(BuffModifiers.INVISIBILITY, (Object)true), new ModifierValue(BuffModifiers.INTIMIDATED, (Object)true), new ModifierValue(BuffModifiers.TARGET_RANGE, (Object)Float.valueOf(-0.8f)));
    }

    private static /* synthetic */ void lambda$addDrawables$0(TextureDrawOptions shadow, TickManager tm) {
        shadow.draw();
    }
}

