/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonmounts;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.stream.Stream;
import necesse.engine.Settings;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.input.Control;
import necesse.engine.localization.Localization;
import necesse.engine.modifiers.ModifierValue;
import necesse.engine.network.Packet;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.ActiveMountAbility;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.StaminaBuff;
import necesse.entity.mobs.summon.summonFollowingMob.mountFollowingMob.MountFollowingMob;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class ChiefSummonMount
extends MountFollowingMob
implements ActiveMountAbility {
    public static GameTexture texture;
    public static GameTexture texture_mask;
    protected int ChiefAxeCharge = 0;

    public ChiefSummonMount() {
        super(100);
        this.setSpeed(60.0f);
        this.setFriction(3.0f);
        this.setSwimSpeed(0.0f);
        this.collision = new Rectangle(-10, -7, 20, 14);
        this.hitBox = new Rectangle(-26, -24, 52, 48);
        this.selectBox = new Rectangle(-19, -52, 38, 64);
    }

    public void onActiveMountAbilityStarted(PlayerMob player, Packet content) {
        this.ChiefAxeCharge = 20;
    }

    public boolean tickActiveMountAbility(PlayerMob player, boolean isRunningClient) {
        this.ChiefAxeCharge = 20;
        if (this.ChiefAxeCharge > 0) {
            long msToDeplete = 9000L;
            float usage = 50.0f / (float)msToDeplete;
            if (!StaminaBuff.useStaminaAndGetValid((Mob)player, (float)usage)) {
                return false;
            }
            player.buffManager.addBuff(new ActiveBuff(BuffRegistry.getBuff((String)"chiefbuff"), (Mob)player, 1.0f, (Attacker)this), true);
        }
        return !isRunningClient || Control.TRINKET_ABILITY.isDown();
    }

    public void onActiveMountAbilityUpdate(PlayerMob player, Packet content) {
    }

    public void onActiveMountAbilityStopped(PlayerMob player) {
        this.ChiefAxeCharge = 0;
    }

    public boolean canRunMountAbility(PlayerMob player, Packet content) {
        return player.isServer() && !Settings.strictServerAuthority ? true : StaminaBuff.canStartStaminaUsage((Mob)player);
    }

    public void serverTick() {
        super.serverTick();
        if (this.ChiefAxeCharge > 0) {
            --this.ChiefAxeCharge;
        }
    }

    public void clientTick() {
        super.clientTick();
        if (this.ChiefAxeCharge > 0) {
            --this.ChiefAxeCharge;
        }
    }

    protected String getInteractTip(PlayerMob perspective, boolean debug) {
        return this.isMounted() ? null : Localization.translate((String)"controls", (String)"usetip");
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 5; ++i) {
            int sprite = GameRandom.globalRandom.nextInt(7);
            this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), MobRegistry.Textures.chieftain.body, sprite % 4, 8 + i / 4, 64, this.x, this.y, 10.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 64;
        int drawY = camera.getDrawY(y) - 86;
        int dir = this.getDir();
        Point sprite = this.getAnimSprite(x, y, dir);
        drawY += this.getBobbing(x, y);
        TextureDrawOptionsEnd options = texture.initDraw().sprite(sprite.x, sprite.y, 128).light(light).pos(drawX - 2, drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this));
        list.add(new MobDrawable((DrawOptions)options){
            final /* synthetic */ DrawOptions val$options;
            {
                this.val$options = drawOptions;
            }

            public void draw(TickManager tickManager) {
            }

            public void drawBehindRider(TickManager tickManager) {
                this.val$options.draw();
            }
        });
    }

    public Point getSpriteOffset(int spriteX, int spriteY) {
        Point point = new Point(0, 0);
        if (this.isAccelerating() && (spriteX == 1 || spriteX == 2)) {
            point.y = -5;
        }
        point.x += this.getRiderDrawXOffset();
        point.y += this.getRiderDrawYOffset() + 12;
        return point;
    }

    public int getRiderDrawYOffset() {
        PlayerMob player = (PlayerMob)this.getFollowingMob();
        if (player != null) {
            return -25;
        }
        return 0;
    }

    public GameTexture getRiderMask() {
        return texture_mask;
    }

    public int getRockSpeed() {
        return 50;
    }

    public Stream<ModifierValue<?>> getDefaultRiderModifiers() {
        return Stream.of(new ModifierValue(BuffModifiers.MAX_SUMMONS, (Object)1), new ModifierValue(BuffModifiers.ARMOR, (Object)Float.valueOf(0.1f)), new ModifierValue(BuffModifiers.MAX_HEALTH, (Object)Float.valueOf(0.1f)));
    }
}

