/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonmounts;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.modifiers.ModifierValue;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.packet.PacketMobMount;
import necesse.engine.registries.MobRegistry;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.SoundPlayer;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.summon.MinecartLinePos;
import necesse.entity.mobs.summon.MinecartLines;
import necesse.entity.mobs.summon.summonFollowingMob.mountFollowingMob.MountFollowingMob;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.gameObject.GameObject;
import necesse.level.gameObject.MinecartTrackObject;
import necesse.level.gameObject.TrapTrackObject;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import necesse.level.maps.regionSystem.RegionPositionGetter;

public class CavelingMinecartMount
extends MountFollowingMob {
    public float minecartSpeed;
    public int minecartDir;
    public float collisionMovementBuffer;
    public Point collisionMovementLastPos;
    protected SoundPlayer movingSound;
    protected SoundPlayer breakingSound;
    protected float breakParticleBuffer;
    protected boolean breakParticleAlternate;
    public static GameTexture texture;

    public CavelingMinecartMount() {
        super(1);
        this.setSpeed(200.0f);
        this.setFriction(3.0f);
        this.accelerationMod = 0.1f;
        this.setKnockbackModifier(0.1f);
        this.collision = new Rectangle(-10, -10, 20, 14);
        this.hitBox = new Rectangle(-14, -15, 28, 24);
        this.selectBox = new Rectangle(-14, -20, 28, 30);
        this.swimMaskMove = 8;
        this.swimMaskOffset = -2;
        this.swimSinkOffset = 0;
        this.overrideMountedWaterWalking = true;
        this.staySmoothSnapped = true;
    }

    protected GameMessage getSummonLocalization() {
        return MobRegistry.getLocalization((String)"cavelingminecart");
    }

    public void addSaveData(SaveData save) {
        super.addSaveData(save);
        save.addInt("minecartDir", this.minecartDir);
        save.addFloat("minecartSpeed", this.minecartSpeed);
    }

    public void applyLoadData(LoadData save) {
        super.applyLoadData(save);
        this.minecartDir = save.getInt("minecartDir", this.minecartDir);
        this.minecartSpeed = save.getFloat("minecartSpeed", this.minecartSpeed);
    }

    public void setupMovementPacket(PacketWriter writer) {
        super.setupMovementPacket(writer);
        writer.putNextFloat(this.minecartSpeed);
        writer.putNextMaxValue(this.minecartDir, 3);
    }

    public void applyMovementPacket(PacketReader reader, boolean isDirect) {
        super.applyMovementPacket(reader, isDirect);
        this.minecartSpeed = reader.getNextFloat();
        this.minecartDir = reader.getNextMaxValue(3);
    }

    public void tickCurrentMovement(float delta) {
        super.tickCurrentMovement(delta);
    }

    public void tickMovement(float delta) {
        super.tickMovement(delta);
    }

    protected void tickCollisionMovement(float delta, Mob rider) {
        block60: {
            block59: {
                int tileX = this.getTileX();
                int tileY = this.getTileY();
                GameObject object = this.getLevel().getObject(tileX, tileY);
                if (object instanceof MinecartTrackObject && !(object instanceof TrapTrackObject)) {
                    MinecartTrackObject trackObject = (MinecartTrackObject)object;
                    float colDx = this.colDx / 20.0f;
                    float colDy = this.colDy / 20.0f;
                    float moveX = this.moveX;
                    float moveY = this.moveY;
                    MinecartLines lines = trackObject.getMinecartLines(this.getLevel(), tileX, tileY, moveX, moveY, false);
                    MinecartLinePos pos = lines.getMinecartPos(this.x, this.y, this.minecartDir);
                    if (pos != null) {
                        boolean breaking = false;
                        float moving = 0.0f;
                        if (this.minecartDir == 0) {
                            if (moveY < 0.0f) {
                                moving = 1.0f;
                            } else if (moveY > 0.0f) {
                                breaking = true;
                                moving = -1.0f;
                            }
                            moving -= colDy;
                            colDx = 0.0f;
                        } else if (this.minecartDir == 1) {
                            if (moveX > 0.0f) {
                                moving = 1.0f;
                            } else if (moveX < 0.0f) {
                                breaking = true;
                                moving = -1.0f;
                            }
                            moving += colDx;
                            colDy = 0.0f;
                        } else if (this.minecartDir == 2) {
                            if (moveY > 0.0f) {
                                moving = 1.0f;
                            } else if (moveY < 0.0f) {
                                breaking = true;
                                moving = -1.0f;
                            }
                            moving += colDy;
                            colDx = 0.0f;
                        } else {
                            if (moveX < 0.0f) {
                                moving = 1.0f;
                            } else if (moveX > 0.0f) {
                                breaking = true;
                                moving = -1.0f;
                            }
                            moving -= colDx;
                            colDy = 0.0f;
                        }
                        if (colDx != 0.0f || colDy != 0.0f) {
                            if (this.getLevel().entityManager.players.streamArea(this.x, this.y, 100).filter(arg_0 -> ((CavelingMinecartMount)this).collidesWith(arg_0)).anyMatch(p -> true)) {
                                this.collisionMovementBuffer = (float)((double)this.collisionMovementBuffer + GameMath.diagonalMoveDistance((double)colDx, (double)colDy) * (double)delta / 250.0 * 20.0);
                            }
                            this.collisionMovementLastPos = new Point(this.getX(), this.getY());
                            this.movementUpdateTime = Math.min(this.movementUpdateTime, this.getWorldEntity().getTime() - (long)(this.movementUpdateCooldown - 1000));
                        }
                        float friction = rider == null ? 2.0f : 0.0f;
                        float accMod = this.getAccelerationModifier();
                        float speed = this.getSpeed();
                        if (friction != 0.0f) {
                            this.minecartSpeed += (speed * friction * moving - friction * this.minecartSpeed) * delta / 250.0f * accMod;
                        } else if (moving != 0.0f) {
                            this.minecartSpeed += (speed * moving - this.minecartSpeed) * delta / 250.0f * accMod;
                        }
                        if (this.minecartSpeed < 0.0f) {
                            this.minecartDir = (this.minecartDir + 2) % 4;
                            this.minecartSpeed = 0.0f;
                        }
                        if (moving == 0.0f && Math.abs(this.minecartSpeed) < speed / 40.0f) {
                            this.minecartSpeed = 0.0f;
                        }
                        if (this.minecartSpeed > 0.0f) {
                            MinecartLinePos resultPos = pos.progressLines(this.minecartDir, this.minecartSpeed * delta / 250.0f, (Consumer)null);
                            this.x = resultPos.x;
                            this.y = resultPos.y;
                            this.minecartDir = resultPos.dir;
                            this.setDir(this.minecartDir);
                            if (resultPos.distanceRemainingToTravel > 0.0f) {
                                if (!this.isServer() && this.minecartSpeed > 25.0f) {
                                    SoundManager.playSound((GameSound)GameResources.cling, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(0.6f).pitch(0.8f));
                                }
                                this.minecartSpeed = 0.0f;
                            } else if (!this.isServer()) {
                                if (breaking && moving < 0.0f) {
                                    if (this.minecartSpeed > 10.0f) {
                                        this.breakParticleBuffer += delta;
                                        if (this.breakParticleBuffer > 10.0f) {
                                            this.breakParticleBuffer -= 10.0f;
                                            float xOffset = GameRandom.globalRandom.floatGaussian();
                                            float yOffset = GameRandom.globalRandom.floatGaussian();
                                            boolean alternate = this.breakParticleAlternate;
                                            if (this.minecartDir == 0) {
                                                xOffset += alternate ? 8.0f : -8.0f;
                                                yOffset += 4.0f;
                                            } else if (this.minecartDir == 1) {
                                                yOffset += alternate ? 6.0f : -6.0f;
                                                xOffset -= 4.0f;
                                            } else if (this.minecartDir == 2) {
                                                xOffset += alternate ? 8.0f : -8.0f;
                                                yOffset -= 4.0f;
                                            } else {
                                                yOffset += alternate ? 6.0f : -6.0f;
                                                xOffset += 4.0f;
                                            }
                                            float var10001 = this.x + xOffset;
                                            float var10002 = this.y + yOffset;
                                            this.getLevel().entityManager.addParticle(var10001, var10002, Particle.GType.IMPORTANT_COSMETIC).color(new Color(210, 160, 8)).sizeFadesInAndOut(4, 8, 50, 200).movesConstant(this.dx / 10.0f, this.dy / 10.0f).lifeTime(300).height(2.0f);
                                            boolean bl = this.breakParticleAlternate = !this.breakParticleAlternate;
                                        }
                                    }
                                    if (this.breakingSound == null || this.breakingSound.isDone()) {
                                        this.breakingSound = SoundManager.playSound((GameSound)GameResources.trainBrake, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).falloffDistance(1400).volume(0.0f));
                                    }
                                    if (this.breakingSound != null) {
                                        this.breakingSound.effect.volume(GameMath.limit((float)((this.minecartSpeed - 10.0f) / 100.0f), (float)0.0f, (float)1.0f) * 1.5f);
                                        this.breakingSound.refreshLooping(0.5f);
                                    }
                                }
                                if (this.movingSound == null || this.movingSound.isDone()) {
                                    this.movingSound = SoundManager.playSound((GameSound)GameResources.train, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).falloffDistance(1400).volume(0.0f));
                                }
                                if (this.movingSound != null) {
                                    this.movingSound.effect.volume(Math.min(this.minecartSpeed / 200.0f, 1.0f) / 1.5f);
                                    this.movingSound.refreshLooping(0.2f);
                                }
                            }
                        } else {
                            this.x = pos.x;
                            this.y = pos.y;
                            if (pos.dir != 1 && pos.dir != 3) {
                                if (this.minecartDir == 1 || this.minecartDir == 3) {
                                    this.minecartDir = pos.dir;
                                }
                            } else if (this.minecartDir == 0 || this.minecartDir == 2) {
                                this.minecartDir = pos.dir;
                            }
                            this.setDir(this.minecartDir);
                        }
                    } else {
                        this.minecartSpeed = 0.0f;
                        this.minecartDir = rider == null ? this.getDir() : rider.getDir();
                    }
                } else {
                    this.minecartDir = rider == null ? this.getDir() : rider.getDir();
                    this.dx = 0.0f;
                    this.dy = 0.0f;
                    if (this.colDx != 0.0f || this.colDy != 0.0f) {
                        if (this.getLevel().entityManager.players.streamArea(this.x, this.y, 100).filter(arg_0 -> ((CavelingMinecartMount)this).collidesWith(arg_0)).anyMatch(p -> true)) {
                            this.collisionMovementBuffer = (float)((double)this.collisionMovementBuffer + GameMath.diagonalMoveDistance((double)this.colDx, (double)this.colDy) * (double)delta / 250.0);
                        }
                        this.collisionMovementLastPos = new Point(this.getX(), this.getY());
                        this.movementUpdateTime = Math.min(this.movementUpdateTime, this.getWorldEntity().getTime() - (long)(this.movementUpdateCooldown - 1000));
                    }
                    super.tickCollisionMovement(delta, rider);
                }
                if (this.collisionMovementBuffer >= 5.0f) break block59;
                if (this.collisionMovementLastPos == null) break block60;
                Point point = new Point(this.getX(), this.getY());
                if (!(GameMath.diagonalMoveDistance((Point)this.collisionMovementLastPos, (Point)point) > 32.0)) break block60;
            }
            this.collisionMovementBuffer = 0.0f;
            this.collisionMovementLastPos = null;
            this.sendMovementPacket(false);
        }
    }

    public void serverTick() {
        super.serverTick();
        if (!this.isMounted()) {
            this.moveX = 0.0f;
            this.moveY = 0.0f;
        }
        if (this.inLiquid()) {
            this.setHealth(0);
        }
    }

    public void clientTick() {
        super.clientTick();
        if (!this.isMounted()) {
            this.moveX = 0.0f;
            this.moveY = 0.0f;
        }
    }

    public void spawnDamageText(int damage, int size, boolean isCrit) {
    }

    public void playHitSound() {
    }

    public void interact(PlayerMob player) {
        if (this.isServer()) {
            if (player.getUniqueID() == this.rider) {
                player.dismount();
                this.getLevel().getServer().network.sendToClientsWithEntity((Packet)new PacketMobMount(player.getUniqueID(), -1, false, player.x, player.y), (RegionPositionGetter)player);
            } else if (player.mount((Mob)this, false)) {
                this.getLevel().getServer().network.sendToClientsWithEntity((Packet)new PacketMobMount(player.getUniqueID(), this.getUniqueID(), false, player.x, player.y), (RegionPositionGetter)player);
            }
        }
    }

    public boolean canInteract(Mob mob) {
        return !this.isMounted() || mob.getUniqueID() == this.rider;
    }

    protected String getInteractTip(PlayerMob perspective, boolean debug) {
        return this.isMounted() ? null : Localization.translate((String)"controls", (String)"usetip");
    }

    public void playDeathSound() {
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 32;
        int drawY = camera.getDrawY(y) - 47;
        Point sprite = this.getAnimSprite(x, y, this.minecartDir);
        drawY += this.getBobbing(x, y);
        final MaskShaderOptions swimMask = this.getSwimMaskShaderOptions(this.inLiquidFloat(x, y));
        TextureDrawOptionsEnd behind = texture.initDraw().sprite(sprite.x, sprite.y, 64).addMaskShader(swimMask).light(light).pos(drawX, drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this));
        list.add(new MobDrawable((DrawOptions)behind){
            final /* synthetic */ DrawOptions val$behind;
            {
                this.val$behind = drawOptions;
            }

            public void draw(TickManager tickManager) {
            }

            public void drawBehindRider(TickManager tickManager) {
                swimMask.use();
                this.val$behind.draw();
                swimMask.stop();
            }
        });
        this.addShadowDrawables(tileList, level, x, y, light, camera);
    }

    public static void drawPlacePreview(Level level, int levelX, int levelY, int dir, GameCamera camera) {
        int tileY;
        int tileX;
        Mob mob = MobRegistry.getMob((String)"cavelingminecart", (Level)level);
        if (mob != null) {
            mob.setPos((float)levelX, (float)levelY, true);
            tileX = mob.getTileX();
            tileY = mob.getTileY();
            GameObject object = level.getObject(tileX, tileY);
            if (object instanceof MinecartTrackObject) {
                MinecartTrackObject trackObject = (MinecartTrackObject)object;
                float moveX = 0.0f;
                float moveY = 0.0f;
                if (dir == 0) {
                    moveY = -1.0f;
                } else if (dir == 1) {
                    moveX = 1.0f;
                } else if (dir == 2) {
                    moveY = 1.0f;
                } else {
                    moveX = -1.0f;
                }
                MinecartLines lines = trackObject.getMinecartLines(level, tileX, tileY, moveX, moveY, false);
                MinecartLinePos pos = lines.getMinecartPos((float)levelX, (float)levelY, dir);
                if (pos != null) {
                    int drawX = camera.getDrawX(pos.x) - 32;
                    int drawY = camera.getDrawY(pos.y) - 47;
                    Point sprite = mob.getAnimSprite((int)pos.x, (int)pos.y, pos.dir);
                    drawY += mob.getBobbing((int)pos.x, (int)pos.y);
                    texture.initDraw().sprite(sprite.x, sprite.y, 64).alpha(0.5f).draw(drawX, drawY += level.getTile((int)pos.x / 32, (int)pos.y / 32).getMobSinkingAmount(mob));
                    return;
                }
            }
        }
        tileX = camera.getDrawX(levelX) - 32;
        tileY = camera.getDrawY(levelY) - 47;
        texture.initDraw().sprite(0, dir, 64).alpha(0.5f).draw(tileX, tileY += level.getLevelTile(levelX / 32, levelY / 32).getLiquidBobbing());
    }

    public Point getAnimSprite(int x, int y, int dir) {
        Point p = new Point(0, dir);
        if (!this.inLiquid(x, y)) {
            p.x = (int)(this.getDistanceRan() / (double)this.getRockSpeed()) % 2;
        }
        return p;
    }

    protected TextureDrawOptions getShadowDrawOptions(int x, int y, GameLight light, GameCamera camera) {
        return CavelingMinecartMount.getShadowDrawOptions((Mob)this, x, y, 0, this.minecartDir, light, camera);
    }

    public static TextureDrawOptions getShadowDrawOptions(Mob mob, int x, int y, int yOffset, int dir, GameLight light, GameCamera camera) {
        GameTexture shadowTexture = MobRegistry.Textures.minecart_shadow;
        int drawX = camera.getDrawX(x) - 32;
        int drawY = camera.getDrawY(y) - 47 + yOffset;
        drawY += mob.getBobbing(x, y);
        return shadowTexture.initDraw().sprite(0, dir, 64).light(light).pos(drawX, drawY += mob.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount(mob));
    }

    public int getRockSpeed() {
        return 10;
    }

    public int getWaterRockSpeed() {
        return 10000;
    }

    public Point getSpriteOffset(int spriteX, int spriteY) {
        Point p = new Point(0, 0);
        p.x += this.getRiderDrawXOffset();
        p.y += this.getRiderDrawYOffset();
        return p;
    }

    public int getRiderDrawYOffset() {
        return this.getSwimMaskShaderOptions((float)this.inLiquidFloat((int)this.getDrawX(), (int)this.getDrawY())).drawYOffset - 6;
    }

    public int getRiderArmSpriteX() {
        return 0;
    }

    public GameTexture getRiderMask() {
        return MobRegistry.Textures.minecart_mask[GameMath.limit((int)this.minecartDir, (int)0, (int)(MobRegistry.Textures.minecart_mask.length - 1))];
    }

    public int getRiderMaskYOffset() {
        return -10;
    }

    public boolean isWaterWalking() {
        GameObject object = this.getLevel().getObject(this.getTileX(), this.getTileY());
        return object instanceof MinecartTrackObject ? true : super.isWaterWalking();
    }

    public Stream<ModifierValue<?>> getDefaultRiderModifiers() {
        return Stream.of(new ModifierValue(BuffModifiers.WATER_WALKING, (Object)true), new ModifierValue(BuffModifiers.ITEM_PICKUP_RANGE, (Object)Float.valueOf(5.0f)));
    }
}

