/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonmobs;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.util.GameRandom;
import necesse.entity.ParticleTypeSwitcher;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.ConfusedPlayerChaserWandererAI;
import necesse.entity.mobs.hostile.FlyingHostileMob;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.lootTable.LootItemInterface;
import necesse.inventory.lootTable.LootTable;
import necesse.inventory.lootTable.lootItem.ChanceLootItem;
import necesse.level.maps.IncursionLevel;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class WoodMob
extends FlyingHostileMob {
    public static GameDamage baseDamage = new GameDamage(10.0f);
    public static GameDamage incursionDamage = new GameDamage(50.0f);
    public float moveAngle;
    public static GameTexture texture;
    public ParticleTypeSwitcher particleTypes;
    public static LootTable lootTable;

    public WoodMob() {
        super(100);
        this.setSpeed(40.0f);
        this.setFriction(0.4f);
        this.setKnockbackModifier(0.0f);
        this.setArmor(10);
        this.moveAccuracy = 20;
        this.attackCooldown = 4000;
        this.collision = new Rectangle(0, 0, 24, 32);
        this.hitBox = new Rectangle(0, 0, 24, 32);
        this.selectBox = new Rectangle(0, 0, 24, 32);
        this.particleTypes = new ParticleTypeSwitcher(new Particle.GType[]{Particle.GType.COSMETIC, Particle.GType.IMPORTANT_COSMETIC, Particle.GType.COSMETIC});
    }

    public void init() {
        GameDamage damage;
        super.init();
        if (this.getLevel() instanceof IncursionLevel) {
            this.setMaxHealth(500);
            this.setHealthHidden(this.getMaxHealth());
            this.setArmor(20);
            damage = incursionDamage;
        } else {
            damage = baseDamage;
        }
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new ConfusedPlayerChaserWandererAI<WoodMob>(null, 600, 200, 100, false, true){

            public boolean attackTarget(WoodMob mob, Mob target) {
                boolean success = this.shootSimpleProjectile((Mob)mob, target, "woodmobproj", damage, 10, 250);
                if (success) {
                    this.wanderAfterAttack = GameRandom.globalRandom.getChance(0.25f);
                }
                return success;
            }
        });
    }

    public void clientTick() {
        super.clientTick();
        if (GameRandom.globalRandom.getChance(0.2f)) {
            float particleX = this.x + 20.0f + GameRandom.globalRandom.floatGaussian() * 5.0f;
            float particleY = this.y + 20.0f + GameRandom.globalRandom.floatGaussian() * 10.0f;
            float moveX = GameRandom.globalRandom.floatGaussian() * 10.0f;
            float moveY = GameRandom.globalRandom.floatGaussian() * 10.0f;
            this.getLevel().entityManager.addParticle(particleX, particleY, this.particleTypes.next()).sprite(GameResources.magicSparkParticles.sprite(GameRandom.globalRandom.nextInt(4), 0, 32)).sizeFades(10, 20).movesFriction(moveX, moveY, 0.8f).color(new Color(14, 99, 29)).givesLight(190.0f, 0.9f).height(0.0f).ignoreLight(true).lifeTime(500);
        }
    }

    public LootTable getLootTable() {
        return lootTable;
    }

    protected void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x);
        int drawY = camera.getDrawY(y);
        TextureDrawOptionsEnd body = texture.initDraw().light(light).rotate(this.moveAngle, 0, 0).pos(drawX, drawY);
        topList.add(arg_0 -> WoodMob.lambda$addDrawables$0((DrawOptions)body, arg_0));
    }

    private static /* synthetic */ void lambda$addDrawables$0(DrawOptions body, TickManager tm) {
        body.draw();
    }

    static {
        lootTable = new LootTable(new LootItemInterface[]{ChanceLootItem.between((float)0.2f, (String)"oaklog", (int)1, (int)10), ChanceLootItem.between((float)0.2f, (String)"palmlog", (int)1, (int)10), ChanceLootItem.between((float)0.2f, (String)"pinelog", (int)1, (int)10), ChanceLootItem.between((float)0.2f, (String)"maplelog", (int)1, (int)10), ChanceLootItem.between((float)0.2f, (String)"birchlog", (int)1, (int)10), ChanceLootItem.between((float)0.2f, (String)"sprucelog", (int)1, (int)10), ChanceLootItem.between((float)0.2f, (String)"willowlog", (int)1, (int)10)});
    }
}

