/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonmobs;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import necesse.engine.DifficultyBasedGetter;
import necesse.engine.eventStatusBars.EventStatusBarManager;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.registries.MusicRegistry;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.engine.sound.GameMusic;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.MaxHealthGetter;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.MobHealthScaling;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.AINodeResult;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.Blackboard;
import necesse.entity.mobs.buffs.staticBuffs.BossNearbyBuff;
import necesse.entity.mobs.hostile.bosses.BossMob;
import necesse.entity.particle.Particle;
import necesse.entity.particle.ParticleOption;
import necesse.entity.particle.SmokePuffParticle;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTooltips.GameTooltips;
import necesse.gfx.gameTooltips.StringTooltips;
import necesse.inventory.lootTable.LootItemInterface;
import necesse.inventory.lootTable.LootTable;
import necesse.inventory.lootTable.lootItem.ConditionLootItem;
import necesse.inventory.lootTable.lootItem.LootItem;
import necesse.inventory.lootTable.lootItem.OneOfLootItems;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class RiftPortalMob
extends BossMob {
    public static LootTable lootTable = new LootTable(new LootItemInterface[]{new OneOfLootItems(new LootItemInterface[]{LootItem.between((String)"purehorror", (int)2, (int)20)})});
    public static LootTable privateLootTable = new LootTable(new LootItemInterface[]{new ConditionLootItem("shadowhorrorbag", (r, o) -> {
        ServerClient client = (ServerClient)LootTable.expectExtra(ServerClient.class, (Object[])o, (int)1);
        return client != null && client.playerMob.getInv().getAmount(ItemRegistry.getItem((String)"shadowhorrorbag"), false, false, true, true, "have") == 0;
    })});
    public static MaxHealthGetter MAX_HEALTH = new MaxHealthGetter(1500, 1600, 1700, 1800, 2000);
    protected MobHealthScaling scaling = new MobHealthScaling((Mob)this);
    public static GameTexture texture;
    public static GameTexture icon;
    private long lifeTime;
    private boolean nextPhase = false;

    public RiftPortalMob() {
        super(100);
        this.difficultyChanges.setMaxHealth((DifficultyBasedGetter)MAX_HEALTH);
        this.isSummoned = true;
        this.isHostile = true;
        this.collision = new Rectangle(-40, -40, 50, 50);
        this.hitBox = new Rectangle(-40, -40, 50, 50);
        this.selectBox = new Rectangle(-40, -40, 50, 50);
        this.setKnockbackModifier(0.0f);
        this.setArmor(10000);
    }

    public void addSaveData(SaveData save) {
        super.addSaveData(save);
        save.addLong("lifeTime", this.lifeTime);
    }

    public void applyLoadData(LoadData save) {
        super.applyLoadData(save);
        this.lifeTime = save.getInt("lifeTime", 0);
    }

    public void setupHealthPacket(PacketWriter writer, boolean isFull) {
        this.scaling.setupHealthPacket(writer, isFull);
        super.setupHealthPacket(writer, isFull);
    }

    public void applyHealthPacket(PacketReader reader, boolean isFull) {
        this.scaling.applyHealthPacket(reader, isFull);
        super.applyHealthPacket(reader, isFull);
    }

    public void init() {
        super.init();
        this.lifeTime = 0L;
        this.ai = new BehaviourTreeAI((Mob)this, new RiftPortalAINode());
    }

    public void tickMovement(float delta) {
        this.dx = 0.0f;
        this.dy = 0.0f;
    }

    public void clientTick() {
        super.clientTick();
        SoundManager.setMusic((GameMusic)MusicRegistry.TheFirstTrial, (SoundManager.MusicPriority)SoundManager.MusicPriority.EVENT, (float)1.5f);
        this.getLevel().lightManager.refreshParticleLightFloat(this.x, this.y, 270.0f, 0.7f);
        EventStatusBarManager.registerMobHealthStatusBar((Mob)this);
        BossNearbyBuff.applyAround((Mob)this);
    }

    public void serverTick() {
        super.serverTick();
        this.scaling.serverTick();
        ++this.lifeTime;
        if (this.lifeTime >= 3600L) {
            float armorReduced = this.getArmor() * 10.0f / 100.0f;
            this.setArmor((int)armorReduced);
            this.lifeTime = 0L;
        }
        if (this.getHealth() <= this.getMaxHealth() / 2) {
            this.nextPhase = true;
        }
        BossNearbyBuff.applyAround((Mob)this);
    }

    public void playDeathSound() {
        SoundManager.playSound((GameSound)GameResources.fadedeath3, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this));
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        this.getLevel().entityManager.addParticle((ParticleOption)new SmokePuffParticle(this.getLevel(), (float)this.getX(), (float)this.getY(), new Color(50, 50, 50)), Particle.GType.CRITICAL);
    }

    public boolean shouldDrawOnMap() {
        return true;
    }

    public void drawOnMap(TickManager tickManager, Client client, int x, int y, double tileScale, Rectangle drawBounds, boolean isMinimap) {
        super.drawOnMap(tickManager, client, x, y, tileScale, drawBounds, isMinimap);
        int drawX = x - 16;
        int drawY = y - 16;
        icon.initDraw().sprite(0, 0, 64).size(32, 32).draw(drawX, drawY);
    }

    public Rectangle drawOnMapBox(double tileScale, boolean isMinimap) {
        return new Rectangle(-16, -16, 32, 32);
    }

    public GameTooltips getMapTooltips() {
        return new StringTooltips(this.getDisplayName() + " " + this.getHealth() + "/" + this.getMaxHealth());
    }

    public boolean canBePushed(Mob other) {
        return false;
    }

    public boolean isBoss() {
        return true;
    }

    public boolean isHealthBarVisible() {
        return false;
    }

    public int getMaxHealth() {
        return super.getMaxHealth() + (int)((float)(this.scaling == null ? 0 : this.scaling.getHealthIncrease()) * this.getMaxHealthModifier());
    }

    public LootTable getLootTable() {
        return lootTable;
    }

    public LootTable getPrivateLootTable() {
        return privateLootTable;
    }

    protected void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 60;
        int drawY = camera.getDrawY(y) - 60;
        TextureDrawOptionsEnd body = texture.initDraw().sprite(0, 0, 118).mirror(this.moveX < 0.0f, false).alpha(0.7f).light(light).pos(drawX, drawY);
        topList.add(arg_0 -> RiftPortalMob.lambda$addDrawables$1((DrawOptions)body, arg_0));
    }

    private static /* synthetic */ void lambda$addDrawables$1(DrawOptions body, TickManager tm) {
        body.draw();
    }

    public class RiftPortalAINode<T extends Mob>
    extends AINode<T> {
        private ArrayList<Mob> spawnedMobs = new ArrayList();

        protected void onRootSet(AINode<T> root, T mob, Blackboard<T> blackboard) {
            blackboard.onRemoved(e -> this.spawnedMobs.forEach(Mob::remove));
        }

        public void init(T mob, Blackboard<T> blackboard) {
        }

        public AINodeResult tick(T mob, Blackboard<T> blackboard) {
            if (RiftPortalMob.this.nextPhase) {
                if (RiftPortalMob.this.lifeTime % 600L == 0L) {
                    Mob portalMob = MobRegistry.getMob((String)"horrorspiritmob", (Level)RiftPortalMob.this.getLevel());
                    RiftPortalMob.this.getLevel().entityManager.addMob(portalMob, (float)(RiftPortalMob.this.getX() + (int)(GameRandom.globalRandom.nextGaussian() * 3.0)), (float)(RiftPortalMob.this.getY() + (int)(GameRandom.globalRandom.nextGaussian() * 3.0)));
                    this.spawnedMobs.add(portalMob);
                }
                if (RiftPortalMob.this.nextPhase && RiftPortalMob.this.lifeTime % 400L == 0L) {
                    Mob portalMob2 = MobRegistry.getMob((String)"horrorspiritbossmob", (Level)RiftPortalMob.this.getLevel());
                    RiftPortalMob.this.getLevel().entityManager.addMob(portalMob2, (float)(RiftPortalMob.this.getX() + (int)(GameRandom.globalRandom.nextGaussian() * 3.0)), (float)(RiftPortalMob.this.getY() + (int)(GameRandom.globalRandom.nextGaussian() * 3.0)));
                    this.spawnedMobs.add(portalMob2);
                }
            } else if (RiftPortalMob.this.lifeTime % 100L == 0L) {
                Mob portalMob = MobRegistry.getMob((String)"horrorspiritmob", (Level)RiftPortalMob.this.getLevel());
                RiftPortalMob.this.getLevel().entityManager.addMob(portalMob, (float)(RiftPortalMob.this.getX() + (int)(GameRandom.globalRandom.nextGaussian() * 3.0)), (float)(RiftPortalMob.this.getY() + (int)(GameRandom.globalRandom.nextGaussian() * 3.0)));
                this.spawnedMobs.add(portalMob);
            }
            return AINodeResult.SUCCESS;
        }
    }
}

