/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonmobs;

import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.registries.MobRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.engine.util.GameUtils;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.CollisionPlayerChaserWandererAI;
import necesse.entity.mobs.ai.behaviourTree.util.AIMover;
import necesse.entity.mobs.ai.behaviourTree.util.FlyingAIMover;
import necesse.entity.mobs.hostile.FlyingHostileMob;
import necesse.entity.particle.Particle;
import necesse.entity.particle.TopFleshParticle;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.lootTable.LootItemInterface;
import necesse.inventory.lootTable.LootTable;
import necesse.inventory.lootTable.lootItem.ChanceLootItem;
import necesse.level.maps.IncursionLevel;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class HorrorSpiritMob
extends FlyingHostileMob {
    public static GameTexture texture;
    public static GameDamage baseDamage;
    public static GameDamage incursionDamage;
    public static LootTable lootTable;

    public HorrorSpiritMob() {
        super(250);
        this.setArmor(50);
        this.setSpeed(35.0f);
        this.setFriction(0.5f);
        this.setKnockbackModifier(0.2f);
        this.moveAccuracy = 10;
        this.collision = new Rectangle(-12, -12, 24, 24);
        this.hitBox = new Rectangle(-16, -16, 32, 32);
        this.selectBox = new Rectangle(-18, -40, 36, 54);
    }

    public void init() {
        GameDamage damage;
        super.init();
        if (this.getLevel() instanceof IncursionLevel) {
            this.setMaxHealth(550);
            this.setHealthHidden(this.getMaxHealth());
            this.setArmor(60);
            damage = incursionDamage;
        } else {
            damage = baseDamage;
        }
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new CollisionPlayerChaserWandererAI(null, 600, damage, 100, 40000), (AIMover)new FlyingAIMover());
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 4; ++i) {
            int sprite = GameRandom.globalRandom.nextInt(4);
            this.getLevel().entityManager.addParticle((Particle)new TopFleshParticle(this.getLevel(), texture, 4 + sprite % 2, sprite / 2, 32, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    public LootTable getLootTable() {
        return lootTable;
    }

    public void playDeathSound() {
        SoundManager.playSound((GameSound)GameResources.fadedeath3, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this));
    }

    protected void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int bobbing = (int)(GameUtils.getBobbing((long)level.getWorldEntity().getTime(), (int)1000) * 5.0f);
        int drawX = camera.getDrawX(x) - 32;
        int drawY = camera.getDrawY(y) - 48 + bobbing;
        int anim = Math.abs(GameUtils.getAnim((long)level.getWorldEntity().getTime(), (int)4, (int)1000) - 3);
        TextureDrawOptionsEnd body = texture.initDraw().sprite(0, anim, 64).mirror(this.moveX < 0.0f, false).alpha(0.7f).light(light).pos(drawX, drawY);
        int minLight = 100;
        TextureDrawOptionsEnd eyes = texture.initDraw().sprite(1, anim, 64).mirror(this.moveX < 0.0f, false).alpha(0.7f).light(light.minLevelCopy((float)minLight)).pos(drawX, drawY);
        this.addShadowDrawables(topList, level, x, y, light, camera);
        topList.add(arg_0 -> HorrorSpiritMob.lambda$addDrawables$0((DrawOptions)body, (DrawOptions)eyes, arg_0));
    }

    protected TextureDrawOptions getShadowDrawOptions(int x, int y, GameLight light, GameCamera camera) {
        GameTexture shadowTexture = MobRegistry.Textures.human_shadow;
        int res = shadowTexture.getHeight();
        int drawX = camera.getDrawX(x) - res / 2;
        int drawY = camera.getDrawY(y) - res / 2 + 4;
        return shadowTexture.initDraw().sprite(0, 0, res).light(light).pos(drawX, drawY);
    }

    private static /* synthetic */ void lambda$addDrawables$0(DrawOptions body, DrawOptions eyes, TickManager tm) {
        body.draw();
        eyes.draw();
    }

    static {
        baseDamage = new GameDamage(60.0f);
        incursionDamage = new GameDamage(80.0f);
        lootTable = new LootTable(new LootItemInterface[]{ChanceLootItem.between((float)0.8f, (String)"purehorror", (int)1, (int)4)});
    }
}

