/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonmobs;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.ConfusedPlayerChaserWandererAI;
import necesse.entity.mobs.hostile.FlyingHostileMob;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.lootTable.LootItemInterface;
import necesse.inventory.lootTable.LootTable;
import necesse.inventory.lootTable.lootItem.ChanceLootItem;
import necesse.level.maps.IncursionLevel;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import summonerexpansion.summonprojs.HorrorSentryProj;

public class HorrorSpiritBossMob
extends FlyingHostileMob {
    public float moveAngle;
    public static GameTexture texture;
    public static GameDamage baseDamage;
    public static GameDamage incursionDamage;
    public static LootTable lootTable;

    public HorrorSpiritBossMob() {
        super(2500);
        this.setArmor(15);
        this.setSpeed(25.0f);
        this.setFriction(0.5f);
        this.setKnockbackModifier(0.2f);
        this.moveAccuracy = 10;
        this.attackCooldown = 3000;
        this.collision = new Rectangle(0, 0, 68, 108);
        this.hitBox = new Rectangle(0, 0, 68, 108);
        this.selectBox = new Rectangle(0, 0, 68, 108);
    }

    public void init() {
        GameDamage damage;
        super.init();
        if (this.getLevel() instanceof IncursionLevel) {
            this.setMaxHealth(5500);
            this.setHealthHidden(this.getMaxHealth());
            this.setArmor(300);
            damage = incursionDamage;
        } else {
            damage = baseDamage;
        }
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new ConfusedPlayerChaserWandererAI<HorrorSpiritBossMob>(null, 600, 600, 40000, false, false){

            public boolean attackTarget(HorrorSpiritBossMob mob, Mob target) {
                if (mob.canAttack()) {
                    HorrorSentryProj projectile = new HorrorSentryProj(HorrorSpiritBossMob.this.getLevel(), (Mob)mob, mob.x, mob.y, target.x, target.y, 75.0f, 512, damage, 50);
                    projectile.x -= projectile.dx * 20.0f;
                    projectile.y -= projectile.dy * 20.0f;
                    HorrorSpiritBossMob.this.attack((int)(mob.x + projectile.dx * 100.0f), (int)(mob.y + projectile.dy * 100.0f), false);
                    HorrorSpiritBossMob.this.getLevel().entityManager.projectiles.add((Entity)projectile);
                    return true;
                }
                return false;
            }
        });
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 20; ++i) {
            this.getLevel().entityManager.addParticle(this.x, this.y, Particle.GType.COSMETIC).movesConstantAngle((float)GameRandom.globalRandom.nextInt(360), (float)GameRandom.globalRandom.getIntBetween(5, 20)).color(new Color(10, 10, 10));
        }
    }

    public LootTable getLootTable() {
        return lootTable;
    }

    public void playDeathSound() {
        SoundManager.playSound((GameSound)GameResources.fadedeath3, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this));
    }

    protected void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x);
        int drawY = camera.getDrawY(y);
        TextureDrawOptionsEnd body = texture.initDraw().light(light).rotate(this.moveAngle, 0, 0).pos(drawX, drawY);
        topList.add(arg_0 -> HorrorSpiritBossMob.lambda$addDrawables$0((DrawOptions)body, arg_0));
    }

    private static /* synthetic */ void lambda$addDrawables$0(DrawOptions body, TickManager tm) {
        body.draw();
    }

    static {
        baseDamage = new GameDamage(150.0f);
        incursionDamage = new GameDamage(300.0f);
        lootTable = new LootTable(new LootItemInterface[]{ChanceLootItem.between((float)1.0f, (String)"purehorror", (int)5, (int)10)});
    }
}

