/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonmobs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.network.server.ServerClient;
import necesse.engine.util.GameLootUtils;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.friendly.human.humanShop.BuyingShopItem;
import necesse.entity.mobs.friendly.human.humanShop.HumanShop;
import necesse.entity.mobs.friendly.human.humanShop.SellingShopItem;
import necesse.gfx.drawOptions.human.HumanDrawOptions;
import necesse.inventory.InventoryItem;
import necesse.inventory.lootTable.LootItemInterface;
import necesse.inventory.lootTable.LootTable;
import necesse.inventory.lootTable.lootItem.CountOfTicketLootItems;
import necesse.inventory.lootTable.lootItem.LootItem;

public class DruidHumanMob
extends HumanShop {
    public DruidHumanMob() {
        super(500, 300, "druid");
        this.attackCooldown = 600;
        this.attackAnimTime = 500;
        this.setSwimSpeed(1.0f);
        this.equipmentInventory.setItem(6, new InventoryItem("woodstaff"));
        this.shop.addSellingItem("leafshotpack", new SellingShopItem(100, 5)).setStaticPriceBasedOnHappiness(800, 1500).addKilledMobRequirement("swampzombie");
        this.shop.addSellingItem("leafshotcoldpack", new SellingShopItem(100, 5)).setStaticPriceBasedOnHappiness(800, 1500).addKilledMobRequirement("trapperzombie");
        this.shop.addSellingItem("leafshotheatpack", new SellingShopItem(100, 5)).setStaticPriceBasedOnHappiness(800, 1500).addKilledMobRequirement("enchantedzombie");
        this.shop.addSellingItem("cactusstaff", new SellingShopItem()).setStaticPriceBasedOnHappiness(1600, 2000);
        this.shop.addSellingItem("sunflowerstaff", new SellingShopItem()).setStaticPriceBasedOnHappiness(600, 1200).addRandomAvailableRequirement(0.2f);
        this.shop.addSellingItem("iceblossomstaff", new SellingShopItem()).setStaticPriceBasedOnHappiness(600, 1200).addRandomAvailableRequirement(0.2f);
        this.shop.addSellingItem("firemonestaff", new SellingShopItem()).setStaticPriceBasedOnHappiness(600, 1200).addRandomAvailableRequirement(0.2f);
        this.shop.addSellingItem("dryadessence", new SellingShopItem()).setStaticPriceBasedOnHappiness(2500, 4000).addKilledMobRequirement("thecursedcrone");
        this.shop.addBuyingItem("redflowerpatch", new BuyingShopItem()).setPriceBasedOnHappiness(10, 2, 3);
        this.shop.addBuyingItem("blueflowerpatch", new BuyingShopItem()).setPriceBasedOnHappiness(10, 2, 3);
        this.shop.addBuyingItem("whiteflowerpatch", new BuyingShopItem()).setPriceBasedOnHappiness(10, 2, 3);
        this.shop.addBuyingItem("purpleflowerpatch", new BuyingShopItem()).setPriceBasedOnHappiness(10, 2, 3);
        this.shop.addBuyingItem("yellowflowerpatch", new BuyingShopItem()).setPriceBasedOnHappiness(10, 2, 3);
    }

    public LootTable getLootTable() {
        return super.getLootTable();
    }

    public void setDefaultArmor(HumanDrawOptions drawOptions) {
        drawOptions.helmet(new InventoryItem("dryadscarf"));
        drawOptions.chestplate(new InventoryItem("dryadchestplate"));
        drawOptions.boots(new InventoryItem("dryadboots"));
    }

    protected ArrayList<GameMessage> getMessages(ServerClient client) {
        return this.getLocalMessages("druidtalk", 4);
    }

    public List<InventoryItem> getRecruitItems(ServerClient client) {
        if (this.isTrapped()) {
            return Collections.emptyList();
        }
        GameRandom random = new GameRandom((long)this.getSettlerSeed() * 200L);
        if (this.isVisitor()) {
            return Collections.singletonList(new InventoryItem("coin", random.getIntBetween(1200, 1500)));
        }
        LootTable secondItems = new LootTable(new LootItemInterface[]{new CountOfTicketLootItems(random.getIntBetween(1, 2), new Object[]{30, new LootItem("swampsludge", Integer.MAX_VALUE), 100, new LootItem("thorns", Integer.MAX_VALUE), 50, new LootItem("cattail", Integer.MAX_VALUE)})});
        ArrayList out = GameLootUtils.getItemsValuedAt((GameRandom)random, (int)random.getIntBetween(350, 500), (double)0.2f, (LootItemInterface)new LootItem("coin", Integer.MAX_VALUE), (Object[])new Object[0]);
        out.addAll(GameLootUtils.getItemsValuedAt((GameRandom)random, (int)random.getIntBetween(75, 150), (double)0.2f, (LootItemInterface)secondItems, (Object[])new Object[0]));
        out.sort(Comparator.comparing(InventoryItem::getBrokerValue).reversed());
        return out;
    }
}

