/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonminions;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.registries.ProjectileRegistry;
import necesse.engine.util.GameUtils;
import necesse.entity.Entity;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.PlayerFollowerChaserAI;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.AttackingFollowingMob;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.entity.particle.ParticleOption;
import necesse.entity.particle.SmokePuffParticle;
import necesse.entity.projectile.Projectile;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.human.HumanDrawOptions;
import necesse.gfx.drawOptions.itemAttack.HumanAttackDrawOptions;
import necesse.gfx.drawOptions.itemAttack.ItemAttackDrawOptions;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import summonerexpansion.summonothers.SummonerTextures;

public class VampireMinion
extends AttackingFollowingMob {
    private boolean isBat;

    public VampireMinion() {
        super(10);
        this.setSpeed(50.0f);
        this.setFriction(1.0f);
        this.attackAnimTime = 750;
        this.attackCooldown = 1200;
        this.collision = new Rectangle(-10, -7, 20, 14);
        this.hitBox = new Rectangle(-14, -12, 28, 24);
        this.selectBox = new Rectangle();
        this.swimMaskMove = 16;
        this.swimMaskOffset = -2;
        this.swimSinkOffset = -4;
    }

    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new PlayerFollowerChaserAI<VampireMinion>(600, 320, false, false, 800, 64){

            public boolean attackTarget(VampireMinion mob, Mob target) {
                if (mob.canAttack() && VampireMinion.this.getAttackOwner().buffManager.hasBuff("bloodplatecowlsetbonus") && !mob.isBat) {
                    mob.attack(target.getX(), target.getY(), false);
                    Projectile projectile = ProjectileRegistry.getProjectile((String)"bloodbolt", (Level)mob.getLevel(), (float)mob.x, (float)mob.y, (float)target.x, (float)target.y, (float)100.0f, (int)800, (GameDamage)VampireMinion.this.summonDamage.modFinalMultiplier(1.3f), (Mob)mob);
                    projectile.setTargetPrediction(target, -20.0f);
                    projectile.moveDist(40.0);
                    mob.getLevel().entityManager.projectiles.add((Entity)projectile);
                    return true;
                }
                if (mob.canAttack() && !mob.isBat) {
                    mob.attack(target.getX(), target.getY(), false);
                    Projectile projectile = ProjectileRegistry.getProjectile((String)"bloodbolt", (Level)mob.getLevel(), (float)mob.x, (float)mob.y, (float)target.x, (float)target.y, (float)80.0f, (int)640, (GameDamage)VampireMinion.this.summonDamage, (Mob)mob);
                    projectile.setTargetPrediction(target, -20.0f);
                    projectile.moveDist(20.0);
                    mob.getLevel().entityManager.projectiles.add((Entity)projectile);
                    return true;
                }
                return false;
            }
        });
    }

    private void tickIsBat() {
        boolean nextIsBat;
        boolean bl = nextIsBat = (this.isAccelerating() || this.hasCurrentMovement()) && this.getSpeedModifier() > 0.0f;
        if (this.isBat != nextIsBat) {
            this.isBat = nextIsBat;
            if (this.isClient()) {
                this.getLevel().entityManager.addParticle((ParticleOption)new SmokePuffParticle(this.getLevel(), this.x, this.y), Particle.GType.IMPORTANT_COSMETIC);
            }
        }
    }

    public void clientTick() {
        super.clientTick();
        this.tickIsBat();
    }

    public void serverTick() {
        super.serverTick();
        this.tickIsBat();
    }

    public int getFlyingHeight() {
        return this.isBat ? 20 : super.getFlyingHeight();
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 5; ++i) {
            this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), SummonerTextures.vampireMinion.body, i, 8, 32, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 22 - 10;
        int drawY = camera.getDrawY(y) - 44 - 7;
        int dir = this.getDir();
        Point sprite = this.getAnimSprite(x, y, dir);
        drawY += this.getBobbing(x, y);
        drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this);
        MaskShaderOptions swimMask = this.getSwimMaskShaderOptions(this.inLiquidFloat(x, y));
        HumanDrawOptions humanDrawOptions = new HumanDrawOptions(level, SummonerTextures.vampireMinion).sprite(sprite).dir(dir).mask(swimMask).light(light);
        float animProgress = this.getAttackAnimProgress();
        if (this.isAttacking) {
            ItemAttackDrawOptions attackOptions = ItemAttackDrawOptions.start((int)dir).armSprite(SummonerTextures.vampireMinion.body, 0, 8, 32).swingRotation(animProgress).light(light);
            humanDrawOptions.attackAnim((HumanAttackDrawOptions)attackOptions, animProgress);
        }
        final DrawOptions drawOptions = humanDrawOptions.pos(drawX, drawY);
        list.add(new MobDrawable(){

            public void draw(TickManager tickManager) {
                drawOptions.draw();
            }
        });
        this.addShadowDrawables(tileList, level, x, y, light, camera);
    }

    public Point getAnimSprite(int x, int y, int dir) {
        Point p = new Point(0, dir);
        p.x = !this.isBat ? (!this.inLiquid(x, y) ? 0 : 5) : GameUtils.getAnim((long)this.getWorldEntity().getTime(), (int)4, (int)400) + 1;
        return p;
    }

    public int getRockSpeed() {
        return 25;
    }
}

