/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonminions;

import java.awt.Rectangle;
import java.util.List;
import java.util.function.Predicate;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.registries.BuffRegistry;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.PlayerFollowerCollisionChaserAI;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.AttackingFollowingMob;
import necesse.entity.objectEntity.interfaces.OEVicinityBuff;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class SunflowerSentry
extends AttackingFollowingMob
implements OEVicinityBuff {
    public int flowerRange = 500;
    public static GameTexture texture;
    public float moveAngle;

    public SunflowerSentry() {
        super(10);
        this.setSpeed(0.0f);
        this.setFriction(0.0f);
        this.collision = new Rectangle(0, 0, 34, 66);
        this.hitBox = new Rectangle(0, 0, 34, 66);
        this.selectBox = new Rectangle();
    }

    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new PlayerFollowerCollisionChaserAI(0, null, 0, 0, 90000, 64));
    }

    public Buff[] getBuffs() {
        return new Buff[]{BuffRegistry.getBuff((String)"sunflowerbuff")};
    }

    public int getBuffRange() {
        return this.flowerRange;
    }

    public boolean shouldBuffPlayers() {
        return true;
    }

    public boolean shouldBuffMobs() {
        return true;
    }

    public Predicate<Mob> buffMobsFilter() {
        return m -> m.isHuman && !m.isSummoned && !m.isHostile;
    }

    public void applyBuffs(Mob mob) {
        Buff[] var2;
        for (Buff buff : var2 = this.getBuffs()) {
            if (buff == null) continue;
            ActiveBuff ab = new ActiveBuff(buff, mob, 120, (Attacker)this);
            mob.buffManager.addBuff(ab, false);
        }
    }

    public void tickVicinityBuff(Mob mob) {
        Level level = mob.getLevel();
        int posX = (int)mob.x;
        int posY = (int)mob.y;
        this.tickVicinityBuff(level, posX, posY);
    }

    public void clientTick() {
        super.clientTick();
        this.tickVicinityBuff((Mob)this);
    }

    public void serverTick() {
        super.serverTick();
        this.tickVicinityBuff((Mob)this);
    }

    public Mob getFirstAttackOwner() {
        return this;
    }

    public boolean canBePushed(Mob other) {
        return false;
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 5; ++i) {
            this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), texture, i, 0, 32, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    protected void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 16;
        int drawY = camera.getDrawY(y) - 20;
        TextureDrawOptionsEnd body = texture.initDraw().light(light).rotate(this.moveAngle, 16, 20).pos(drawX, drawY);
        topList.add(arg_0 -> SunflowerSentry.lambda$addDrawables$1((DrawOptions)body, arg_0));
    }

    private static /* synthetic */ void lambda$addDrawables$1(DrawOptions body, TickManager tm) {
        body.draw();
    }
}

