/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonminions;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.stream.Stream;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.modifiers.ModifierValue;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.util.GameRandom;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.RuneSpiritPoolEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.PlayerFollowerCollisionChaserAI;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.AttackingFollowingMob;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.DryadSpiritFollowingMob;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.item.toolItem.summonToolItem.SummonToolItem;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class SpiritGhoulMinion
extends AttackingFollowingMob {
    public static GameTexture texture;
    protected double distanceRanSinceLastPoolSpawn;

    public SpiritGhoulMinion() {
        super(10);
        this.setSpeed(15.0f);
        this.setFriction(4.0f);
        this.setSwimSpeed(1.5f);
        this.moveAccuracy = 8;
        this.collision = new Rectangle(-12, -5, 24, 20);
        this.hitBox = new Rectangle(-16, -8, 32, 26);
        this.selectBox = new Rectangle();
        this.swimMaskMove = 16;
        this.swimMaskOffset = 0;
        this.swimSinkOffset = -4;
    }

    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new PlayerFollowerCollisionChaserAI<SpiritGhoulMinion>(600, this.summonDamage, 50, 900, 800, 100){

            public boolean attackTarget(SpiritGhoulMinion mob, Mob target) {
                if (mob.canAttack()) {
                    mob.attack(target.getX(), target.getY(), false);
                    target.isServerHit(SpiritGhoulMinion.this.summonDamage, mob.dx, mob.dy, 15.0f, (Attacker)mob);
                    Buff dryadHaunted = BuffRegistry.Debuffs.DRYAD_HAUNTED;
                    ActiveBuff ab = new ActiveBuff(dryadHaunted, target, 60.0f, (Attacker)SpiritGhoulMinion.this.getAttackOwner());
                    target.buffManager.addBuff(ab, true);
                    if (target.buffManager.getStacks(dryadHaunted) >= 10) {
                        target.buffManager.removeBuff(dryadHaunted, true);
                        SpiritGhoulMinion.spawnDryadSpirit(SpiritGhoulMinion.this.getAttackOwner());
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public static void spawnDryadSpirit(Mob owner) {
        if (owner != null && owner.isServer()) {
            int maxSummons = 2;
            DryadSpiritFollowingMob summonedMob = (DryadSpiritFollowingMob)MobRegistry.getMob((String)"dryadspirit", (Level)owner.getLevel());
            ((ItemAttackerMob)owner).serverFollowersManager.addFollower("summonedmobtemp", (Mob)summonedMob, FollowPosition.FLYING_CIRCLE_FAST, "summonedmob", 1.0f, p -> maxSummons, null, false);
            Point2D.Float spawnPoint = SummonToolItem.findSpawnLocation((Mob)summonedMob, (Level)owner.getLevel(), (float)owner.x, (float)owner.y);
            owner.getLevel().entityManager.addMob((Mob)summonedMob, spawnPoint.x, spawnPoint.y);
        }
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 4; ++i) {
            this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), MobRegistry.Textures.spiritGhoul.body, i, 8, 32, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 32;
        int drawY = camera.getDrawY(y) - 36;
        int dir = this.getDir();
        Point sprite = this.getAnimSprite(x, y, dir);
        drawY += this.getBobbing(x, y);
        final MaskShaderOptions swimMask = this.getSwimMaskShaderOptions(this.inLiquidFloat(x, y));
        TextureDrawOptionsEnd body = MobRegistry.Textures.spiritGhoul.body.initDraw().sprite(sprite.x, sprite.y, 64).addMaskShader(swimMask).light(light).pos(drawX, drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this));
        list.add(new MobDrawable((DrawOptions)body){
            final /* synthetic */ DrawOptions val$body;
            {
                this.val$body = drawOptions;
            }

            public void draw(TickManager tickManager) {
                swimMask.use();
                this.val$body.draw();
                swimMask.stop();
            }
        });
    }

    public int getSwimMaskMove() {
        return this.getDir() != 2 ? super.getSwimMaskMove() + 4 : super.getSwimMaskMove();
    }

    public int getRockSpeed() {
        return 15;
    }

    public Stream<ModifierValue<?>> getDefaultModifiers() {
        return Stream.of(new ModifierValue(BuffModifiers.FRICTION, (Object)Float.valueOf(0.0f)).min((Object)Float.valueOf(0.75f)));
    }

    public void serverTick() {
        double poolSpawnRunDistance;
        double distanceRan;
        super.serverTick();
        if (!this.inLiquid() && (distanceRan = this.getDistanceRan()) - this.distanceRanSinceLastPoolSpawn > (poolSpawnRunDistance = 16.0)) {
            RuneSpiritPoolEvent event = new RuneSpiritPoolEvent((Mob)this, (int)this.x, (int)this.y, GameRandom.globalRandom, this.summonDamage.modFinalMultiplier(0.5f), 4.0f);
            this.getLevel().entityManager.addLevelEvent((LevelEvent)event);
            this.distanceRanSinceLastPoolSpawn = distanceRan;
        }
    }
}

