/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonminions;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.registries.MobRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.PlayerFollowerChaserAI;
import necesse.entity.mobs.hostile.GiantCaveSpiderMob;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.AttackingFollowingMob;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.entity.projectile.CaveSpiderSpitProjectile;
import necesse.entity.projectile.CaveSpiderWebProjectile;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.item.toolItem.projectileToolItem.ProjectileToolItem;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class SetSpiderBrideMinion
extends AttackingFollowingMob {
    public static GameTexture texture;
    public int lifeStart = 0;
    public int lifeTime = 0;

    public SetSpiderBrideMinion() {
        super(10);
        this.setSpeed(30.0f);
        this.setFriction(3.0f);
        this.attackAnimTime = 500;
        this.attackCooldown = 2000;
        this.collision = new Rectangle(-20, -20, 40, 40);
        this.hitBox = new Rectangle(-30, -25, 60, 50);
        this.selectBox = new Rectangle();
        this.swimMaskMove = 20;
        this.swimMaskOffset = -24;
        this.swimSinkOffset = 0;
    }

    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new PlayerFollowerChaserAI<SetSpiderBrideMinion>(600, 300, true, false, 900, 100){

            public boolean attackTarget(SetSpiderBrideMinion mob, Mob target) {
                if (mob.canAttack()) {
                    int targetDistance = (int)mob.getDistance(target);
                    mob.attack(target.getX(), target.getY(), false);
                    Point point = ProjectileToolItem.controlledRangePosition((GameRandom)GameRandom.globalRandom, (int)mob.getX(), (int)mob.getY(), (int)target.getX(), (int)target.getY(), (int)Math.max(320, targetDistance + 32), (int)32, (int)16);
                    int pointDistance = (int)mob.getDistance(point.x, point.y);
                    if (GameRandom.globalRandom.nextInt(2) == 1) {
                        mob.getLevel().entityManager.projectiles.add((Entity)new CaveSpiderSpitProjectile(GiantCaveSpiderMob.Variant.NORMAL, mob.x, mob.y, (float)point.x, (float)point.y, SetSpiderBrideMinion.this.summonDamage, (Mob)mob, pointDistance));
                    } else if (GameRandom.globalRandom.nextInt(2) == 1) {
                        mob.getLevel().entityManager.projectiles.add((Entity)new CaveSpiderWebProjectile(mob.x, mob.y, (float)point.x, (float)point.y, SetSpiderBrideMinion.this.summonDamage, (Mob)mob, pointDistance));
                    } else {
                        mob.getLevel().entityManager.projectiles.add((Entity)new CaveSpiderSpitProjectile(GiantCaveSpiderMob.Variant.NORMAL, mob.x, mob.y, (float)point.x, (float)point.y, SetSpiderBrideMinion.this.summonDamage, (Mob)mob, pointDistance));
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public void serverTick() {
        super.serverTick();
        ++this.lifeStart;
        if (this.lifeStart >= this.lifeTime) {
            this.remove(0.0f, 0.0f, null, true);
        }
    }

    public Point getPathMoveOffset() {
        return new Point(32, 32);
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 10; ++i) {
            this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), texture, 14 + i / 5, i % 5, 48, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 48;
        int drawY = camera.getDrawY(y) - 60;
        int dir = this.getDir();
        Point sprite = this.getAnimSprite(x, y, dir);
        drawY += this.getBobbing(x, y);
        drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this);
        if (this.isAttacking) {
            sprite.x = 6;
        }
        final MaskShaderOptions swimMask = this.getSwimMaskShaderOptions(this.inLiquidFloat(x, y));
        TextureDrawOptionsEnd body = texture.initDraw().sprite(sprite.x, sprite.y, 96).addMaskShader(swimMask).light(light).pos(drawX, drawY);
        list.add(new MobDrawable((DrawOptions)body){
            final /* synthetic */ DrawOptions val$body;
            {
                this.val$body = drawOptions;
            }

            public void draw(TickManager tickManager) {
                swimMask.use();
                this.val$body.draw();
                swimMask.stop();
            }
        });
        TextureDrawOptionsEnd shadow = MobRegistry.Textures.giantCaveSpider.shadow.initDraw().sprite(0, sprite.y, 96).light(light).pos(drawX, drawY);
        tileList.add(arg_0 -> SetSpiderBrideMinion.lambda$addDrawables$0((TextureDrawOptions)shadow, arg_0));
    }

    public int getRockSpeed() {
        return 15;
    }

    public float getAttackingMovementModifier() {
        return 0.0f;
    }

    public void attack(int x, int y, boolean showAllDirections) {
        super.attack(x, y, showAllDirections);
        this.setFacingDir(this.attackDir.x, this.attackDir.y);
    }

    public void showAttack(int x, int y, int seed, boolean showAllDirections) {
        super.showAttack(x, y, seed, showAllDirections);
        this.setFacingDir(this.attackDir.x, this.attackDir.y);
        if (this.isClient()) {
            SoundManager.playSound((GameSound)GameResources.spit, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this));
        }
    }

    private static /* synthetic */ void lambda$addDrawables$0(TextureDrawOptions shadow, TickManager tm) {
        shadow.draw();
    }
}

