/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonminions;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.registries.MobRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.WaitForSecondsEvent;
import necesse.entity.manager.EntityManager;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.PlayerFollowerChaserAI;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.AttackingFollowingMob;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.entity.projectile.CrazedRavenFeatherProjectile;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.human.HumanDrawOptions;
import necesse.gfx.drawOptions.itemAttack.HumanAttackDrawOptions;
import necesse.gfx.drawOptions.itemAttack.ItemAttackDrawOptions;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class SetRavenlordMinion
extends AttackingFollowingMob {
    public int throwLife = 0;

    public SetRavenlordMinion() {
        super(10);
        this.setSpeed(40.0f);
        this.setFriction(3.0f);
        this.attackCooldown = 1500;
        this.collision = new Rectangle(-10, -7, 20, 14);
        this.hitBox = new Rectangle(-14, -12, 28, 24);
        this.selectBox = new Rectangle();
        this.swimMaskMove = 16;
        this.swimMaskOffset = -2;
        this.swimSinkOffset = -4;
    }

    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new PlayerFollowerChaserAI<SetRavenlordMinion>(600, 300, false, false, 800, 64){

            public boolean attackTarget(SetRavenlordMinion mob, Mob target) {
                if (mob.canAttack()) {
                    SetRavenlordMinion.fireCrazedRavenProjectiles(mob, target);
                    ++SetRavenlordMinion.this.throwLife;
                    return true;
                }
                return false;
            }
        });
    }

    private static void fireCrazedRavenProjectiles(final SetRavenlordMinion mob, final Mob target) {
        final EntityManager entityManager = mob.getLevel().entityManager;
        mob.attack(target.getX(), target.getY(), false);
        for (int i = 0; i < 2; ++i) {
            CrazedRavenFeatherProjectile duoProjectile = new CrazedRavenFeatherProjectile(mob.getLevel(), mob.x, mob.y, target.x, target.y, 80.0f, 576, mob.summonDamage, (Mob)mob, 50);
            duoProjectile.setAngle(duoProjectile.getAngle() - 30.0f + (float)(i * 60));
            entityManager.projectiles.add((Entity)duoProjectile);
        }
        entityManager.addLevelEventHidden((LevelEvent)new WaitForSecondsEvent(0.5f){

            public void onWaitOver() {
                mob.attack(target.getX(), target.getY(), false);
                CrazedRavenFeatherProjectile singleProjectile = new CrazedRavenFeatherProjectile(mob.getLevel(), mob.x, mob.y, target.x, target.y, 120.0f, 768, mob.summonDamage, (Mob)mob, 50);
                entityManager.projectiles.add((Entity)singleProjectile);
            }
        });
        entityManager.addLevelEventHidden((LevelEvent)new WaitForSecondsEvent(1.0f){

            public void onWaitOver() {
                mob.attack(target.getX(), target.getY(), false);
                for (int i = 0; i < 3; ++i) {
                    CrazedRavenFeatherProjectile duoProjectile = new CrazedRavenFeatherProjectile(mob.getLevel(), mob.x, mob.y, target.x, target.y, 40.0f, 448, mob.summonDamage, (Mob)mob, 50);
                    duoProjectile.setAngle(duoProjectile.getAngle() - 40.0f + (float)(i * 40));
                    entityManager.projectiles.add((Entity)duoProjectile);
                }
            }
        });
    }

    public void clientTick() {
        super.clientTick();
        if (this.isAttacking) {
            this.getAttackAnimProgress();
        }
    }

    public void serverTick() {
        super.serverTick();
        if (this.isAttacking) {
            this.getAttackAnimProgress();
        }
        if (this.throwLife >= 3) {
            this.remove(0.0f, 0.0f, null, true);
        }
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 4; ++i) {
            this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), MobRegistry.Textures.crazedRaven.body, GameRandom.globalRandom.nextInt(6), 8, 32, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(GameMath.getTileCoordinate((int)x), GameMath.getTileCoordinate((int)y));
        int drawX = camera.getDrawX(x) - 22 - 10;
        int drawY = camera.getDrawY(y) - 44 - 7;
        int dir = this.getDir();
        Point sprite = this.getAnimSprite(x, y, dir);
        drawY += this.getBobbing(x, y);
        drawY += this.getLevel().getTile(GameMath.getTileCoordinate((int)x), GameMath.getTileCoordinate((int)y)).getMobSinkingAmount((Mob)this);
        MaskShaderOptions swimMask = this.getSwimMaskShaderOptions(this.inLiquidFloat(x, y));
        HumanDrawOptions humanDrawOptions = new HumanDrawOptions(level, MobRegistry.Textures.crazedRaven).sprite(sprite).dir(dir).mask(swimMask).light(light);
        float animProgress = this.getAttackAnimProgress();
        if (this.isAttacking) {
            ItemAttackDrawOptions attackOptions = ItemAttackDrawOptions.start((int)dir).armSprite(MobRegistry.Textures.crazedRaven.body, 0, 8, 32).swingRotation(animProgress).light(light);
            humanDrawOptions.attackAnim((HumanAttackDrawOptions)attackOptions, animProgress);
        }
        final DrawOptions drawOptions = humanDrawOptions.pos(drawX, drawY);
        list.add(new MobDrawable(){

            public void draw(TickManager tickManager) {
                drawOptions.draw();
            }
        });
        this.addShadowDrawables(tileList, level, x, y, light, camera);
    }

    public int getRockSpeed() {
        return 20;
    }

    public void showAttack(int x, int y, int seed, boolean showAllDirections) {
        super.showAttack(x, y, seed, showAllDirections);
        if (this.isClient()) {
            SoundManager.playSound((GameSound)GameResources.magicbolt1, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).pitch(1.4f));
        }
    }
}

