/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonminions;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.registries.MobRegistry;
import necesse.engine.registries.ProjectileRegistry;
import necesse.engine.sound.SoundSettings;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ability.BooleanMobAbility;
import necesse.entity.mobs.ability.MobAbility;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.PlayerFollowerChaserAI;
import necesse.entity.mobs.ai.behaviourTree.util.AIMover;
import necesse.entity.mobs.ai.behaviourTree.util.FlyingAIMover;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.FlyingAttackingFollowingMob;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.entity.projectile.Projectile;
import necesse.entity.trails.Trail;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.Drawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class SetGhostCaptainMinion
extends FlyingAttackingFollowingMob {
    public int lifeStart = 0;
    public int lifeTime = 0;
    public Trail trail;
    public float moveAngle;
    boolean isBroadsideAttacking;
    protected BooleanMobAbility chargeBroardsideAttack;

    public SetGhostCaptainMinion() {
        super(10);
        this.moveAccuracy = 15;
        this.setSpeed(50.0f);
        this.setFriction(2.0f);
        this.collision = new Rectangle(-18, -15, 36, 30);
        this.hitBox = new Rectangle(-18, -15, 36, 36);
        this.selectBox = new Rectangle();
        this.chargeBroardsideAttack = (BooleanMobAbility)this.registerAbility((MobAbility)new BooleanMobAbility(){

            protected void run(boolean value) {
            }
        });
    }

    public void clientTick() {
        super.clientTick();
        Level level = this.getLevel();
        if (level.tickManager().getTotalTicks() % 2L == 0L) {
            level.entityManager.addParticle(this.x + (float)(GameRandom.globalRandom.nextGaussian() * 14.0), this.y + (float)(GameRandom.globalRandom.nextGaussian() * 30.0), Particle.GType.COSMETIC).movesConstant(this.dx / 10.0f, this.dy / 10.0f).color(new Color(176, 234, 190)).sizeFades(6, 10).height(42.0f);
        }
        level.lightManager.refreshParticleLightFloat(this.x, this.y, 200.0f, 0.6f, 10);
    }

    public void serverTick() {
        super.serverTick();
        ++this.lifeStart;
        if (this.lifeStart >= this.lifeTime) {
            this.remove(0.0f, 0.0f, null, true);
        }
    }

    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new PlayerFollowerChaserAI<SetGhostCaptainMinion>(576, 320, false, false, 9000, 100){

            public boolean attackTarget(SetGhostCaptainMinion mob, Mob target) {
                if (mob.canAttack()) {
                    mob.attack(target.getX(), target.getY(), false);
                    Projectile projectile = ProjectileRegistry.getProjectile((String)"ghostskull", (Level)mob.getLevel(), (float)mob.x, (float)mob.y, (float)target.x, (float)target.y, (float)110.0f, (int)640, (GameDamage)SetGhostCaptainMinion.this.summonDamage, (Mob)mob);
                    projectile.setTargetPrediction(target, -20.0f);
                    projectile.moveDist(20.0);
                    mob.getLevel().entityManager.projectiles.add((Entity)projectile);
                    return true;
                }
                return false;
            }
        }, (AIMover)new FlyingAIMover());
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 7; ++i) {
            this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), MobRegistry.Textures.ghostShip, i, 10, 32, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    protected SoundSettings getHitDeathSound() {
        return new SoundSettings(GameResources.fadedeath3).volume(0.5f).basePitch(1.5f);
    }

    protected void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(GameMath.getTileCoordinate((int)x), GameMath.getTileCoordinate((int)y));
        float rotate = GameMath.limit((float)(this.dx / 10.0f), (float)-10.0f, (float)10.0f);
        int drawX = camera.getDrawX(x) - 64;
        int drawY = camera.getDrawY(y) - 80;
        int timePerFrame = 150;
        int spriteIndex = (int)(this.getWorldEntity().getTime() / (long)timePerFrame) % 4;
        TextureDrawOptionsEnd options = MobRegistry.Textures.ghostShip.initDraw().sprite(spriteIndex, this.isBroadsideAttacking ? 1 : 0, 128, 160).size(128, 160).rotate(rotate).light(light.minLevelCopy(150.0f)).pos(drawX, drawY -= this.getFlyingHeight()).alpha(0.75f);
        topList.add((Drawable)new MobDrawable((DrawOptions)options){
            final /* synthetic */ DrawOptions val$options;
            {
                this.val$options = drawOptions;
            }

            public void draw(TickManager tickManager) {
                this.val$options.draw();
            }
        });
    }
}

