/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonminions;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.registries.MobRegistry;
import necesse.engine.registries.ProjectileRegistry;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.PlayerFollowerChaserAI;
import necesse.entity.mobs.friendly.human.HumanMob;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.AttackingFollowingMob;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.entity.projectile.ButchersCleaverBoomerangProjectile;
import necesse.entity.projectile.Projectile;
import necesse.gfx.GameHair;
import necesse.gfx.GameSkin;
import necesse.gfx.HumanGender;
import necesse.gfx.HumanLook;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.human.HumanDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.inventory.InventoryItem;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class SetChefMinion
extends AttackingFollowingMob {
    protected HumanLook look;
    protected int lookSeed;
    private String mobName = "";
    public int lifeTime = 0;
    public int lifeStart = 0;

    public SetChefMinion() {
        super(10);
        this.setSpeed(30.0f);
        this.setFriction(3.0f);
        this.collision = new Rectangle(-10, -7, 20, 14);
        this.hitBox = new Rectangle(-14, -12, 28, 24);
        this.selectBox = new Rectangle(-14, -41, 28, 48);
        this.swimMaskMove = 16;
        this.swimMaskOffset = -2;
        this.swimSinkOffset = -4;
        this.look = new HumanLook();
        this.getLookSeed();
        this.updateLook();
    }

    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        writer.putNextInt(this.lookSeed);
        writer.putNextString(this.mobName);
    }

    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.lookSeed = reader.getNextInt();
        this.mobName = reader.getNextString();
        this.updateLook();
    }

    public void init() {
        super.init();
        this.updateLook();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new PlayerFollowerChaserAI<SetChefMinion>(600, 600, true, false, 900, 80){

            public boolean attackTarget(SetChefMinion mob, Mob target) {
                if (mob.canAttack()) {
                    mob.attack(target.getX(), target.getY(), false);
                    Projectile projectile = ProjectileRegistry.getProjectile((String)"chefsspecialrollingpin", (Level)mob.getLevel(), (float)mob.x, (float)mob.y, (float)target.x, (float)target.y, (float)180.0f, (int)600, (GameDamage)SetChefMinion.this.summonDamage, (Mob)mob);
                    projectile.setTargetPrediction(target, -20.0f);
                    projectile.moveDist(40.0);
                    if (GameRandom.globalRandom.nextInt(5) == 1) {
                        mob.getLevel().entityManager.projectiles.add((Entity)projectile);
                    } else {
                        mob.getLevel().entityManager.projectiles.add((Entity)new ButchersCleaverBoomerangProjectile(mob.getLevel(), (Mob)mob, mob.x, mob.y, target.x, target.y, 180.0f, 600, SetChefMinion.this.summonDamage, 0.0f, 25, 3, false));
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public void serverTick() {
        super.serverTick();
        ++this.lifeStart;
        if (this.lifeStart >= this.lifeTime) {
            this.remove(0.0f, 0.0f, null, true);
        }
    }

    public void updateLook() {
        if (this.lookSeed == 0) {
            this.lookSeed = GameRandom.globalRandom.nextInt();
        }
        GameRandom random = new GameRandom((long)this.lookSeed);
        HumanGender gender = (HumanGender)random.getOneOfWeighted(HumanGender.class, new Object[]{40, HumanGender.MALE, 40, HumanGender.FEMALE, 20, HumanGender.NEUTRAL});
        this.look.setSkin(((Integer)random.getOneOf((Object[])new Integer[]{0, 1, 2, 3, 13, 14, 17, 18})).intValue());
        this.look.setEyeType(random.getIntBetween(0, 11));
        this.look.setEyeColor(random.getIntBetween(0, 11));
        this.look.setHair(GameHair.getRandomHairBasedOnGender((GameRandom)random, (HumanGender)gender));
        if (gender == HumanGender.MALE) {
            this.look.setFacialFeature(random.getIntBetween(1, 7));
        }
        this.look.setHairColor(GameHair.getRandomHairColorAboveColorWeight((GameRandom)random, (int)GameHair.UNCOMMON_HAIR_COLOR_WEIGHT));
        this.mobName = HumanMob.getRandomName((GameRandom)random, (HumanGender)gender);
    }

    public void getLookSeed() {
        if (this.lookSeed == 0) {
            this.lookSeed = GameRandom.globalRandom.nextInt();
        }
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        GameSkin gameSkin = this.look.getGameSkin(true);
        for (int i = 0; i < 4; ++i) {
            this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), gameSkin, GameRandom.globalRandom.nextInt(5), 8, 32, this.x, this.y, 10.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 22 - 10;
        int drawY = camera.getDrawY(y) - 44 - 7;
        int dir = this.getDir();
        float animProgress = this.getAttackAnimProgress();
        Point sprite = this.getAnimSprite(x, y, dir);
        boolean inLiquid = this.inLiquid(x, y);
        if (inLiquid) {
            sprite.x = 0;
        }
        drawY += this.getBobbing(x, y);
        drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this);
        MaskShaderOptions swimMask = this.getSwimMaskShaderOptions(this.inLiquidFloat(x, y));
        HumanDrawOptions humanDrawOptions = new HumanDrawOptions(level, this.look, false).sprite(sprite).dir(dir).mask(swimMask).light(light).helmet(new InventoryItem("battlechefhat")).chestplate(new InventoryItem("battlechefchestplate")).boots(new InventoryItem("battlechefboots"));
        if (inLiquid) {
            humanDrawOptions.armSprite(2);
            humanDrawOptions.mask(MobRegistry.Textures.boat_mask[sprite.y % 4], 0, -7);
        }
        DrawOptions drawOptions = humanDrawOptions.pos(drawX, drawY);
        TextureDrawOptionsEnd boat = inLiquid ? MobRegistry.Textures.steelBoat.initDraw().sprite(0, sprite.y, 64).light(light).pos(drawX, drawY + 7) : null;
        list.add(new MobDrawable((DrawOptions)boat, drawOptions){
            final /* synthetic */ DrawOptions val$boat;
            final /* synthetic */ DrawOptions val$drawOptions;
            {
                this.val$boat = drawOptions;
                this.val$drawOptions = drawOptions2;
            }

            public void draw(TickManager tickManager) {
                if (this.val$boat != null) {
                    this.val$boat.draw();
                }
                this.val$drawOptions.draw();
            }
        });
        this.addShadowDrawables(tileList, level, x, y, light, camera);
    }
}

