/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonminions;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.gameNetworkData.GNDItem;
import necesse.engine.network.gameNetworkData.GNDItemGameDamage;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.ToolItemMobAbilityEvent;
import necesse.entity.mobs.AttackAnimMob;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.PlayerFollowerCollisionChaserAI;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.AttackingFollowingMob;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.HumanLook;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.human.HumanDrawOptions;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.inventory.InventoryItem;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class SetAgedChampionMinion
extends AttackingFollowingMob {
    protected int lookSeed;
    protected HumanLook look;

    public SetAgedChampionMinion() {
        super(10);
        this.setSpeed(45.0f);
        this.setFriction(3.0f);
        this.collision = new Rectangle(-10, -7, 20, 14);
        this.hitBox = new Rectangle(-14, -12, 28, 24);
        this.selectBox = new Rectangle();
        this.swimMaskMove = 16;
        this.swimMaskOffset = -2;
        this.swimSinkOffset = -4;
        this.look = new HumanLook();
        this.updateLook();
    }

    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        writer.putNextInt(this.lookSeed);
    }

    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.lookSeed = reader.getNextInt();
        this.updateLook();
    }

    public void init() {
        super.init();
        this.updateLook();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new PlayerFollowerCollisionChaserAI<SetAgedChampionMinion>(500, this.summonDamage, 60, 1000, 900, 80){

            public boolean attackTarget(SetAgedChampionMinion mob, Mob target) {
                if (SetAgedChampionMinion.this.canAttack()) {
                    mob.attack(target.getX(), target.getY(), true);
                    InventoryItem attackItem = new InventoryItem("agedchampionsword");
                    attackItem.getGndData().setItem("damage", (GNDItem)new GNDItemGameDamage(SetAgedChampionMinion.this.summonDamage));
                    SetAgedChampionMinion.this.getLevel().entityManager.addLevelEvent((LevelEvent)new ToolItemMobAbilityEvent((AttackAnimMob)SetAgedChampionMinion.this, GameRandom.globalRandom.nextInt(), attackItem, mob.getX(), mob.getY(), SetAgedChampionMinion.this.attackAnimTime, SetAgedChampionMinion.this.attackAnimTime));
                    return true;
                }
                return false;
            }
        });
    }

    public void updateLook() {
        if (this.lookSeed == 0) {
            this.lookSeed = GameRandom.globalRandom.nextInt();
        }
        GameRandom random = new GameRandom((long)this.lookSeed);
        this.look.setFacialFeature(0);
        this.look.setSkin(random.getIntBetween(0, 5));
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 50; ++i) {
            int angle = GameRandom.globalRandom.nextInt(360);
            Point2D.Float dir = GameMath.getAngleDir((float)angle);
            int lifeTime = GameRandom.globalRandom.getIntBetween(2000, 5000);
            float lifePerc = (float)lifeTime / 5000.0f;
            float startHeight = GameRandom.globalRandom.getIntBetween(0, 10);
            float height = startHeight + (float)GameRandom.globalRandom.getIntBetween(70, 150) * lifePerc;
            this.getLevel().entityManager.addParticle(this.x + GameRandom.globalRandom.getFloatBetween(-10.0f, 10.0f), this.y + GameRandom.globalRandom.getFloatBetween(-5.0f, 5.0f), Particle.GType.IMPORTANT_COSMETIC).sprite(GameResources.puffParticles.sprite(GameRandom.globalRandom.nextInt(5), 0, 12)).sizeFades(15, 20).movesFriction((float)GameRandom.globalRandom.getIntBetween(2, 36) * dir.x, (float)GameRandom.globalRandom.getIntBetween(2, 36) * dir.y, 1.0f).heightMoves(startHeight, height).color(this.getDeathParticleColor(GameRandom.globalRandom)).lifeTime(lifeTime);
        }
    }

    protected Color getDeathParticleColor(GameRandom random) {
        return new Color(random.getIntBetween(22, 88), random.getIntBetween(22, 33), random.getIntBetween(22, 88));
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 22 - 10;
        int drawY = camera.getDrawY(y) - 44 - 7;
        int dir = this.getDir();
        float animProgress = this.getAttackAnimProgress();
        Point sprite = this.getAnimSprite(x, y, dir);
        drawY += this.getBobbing(x, y);
        drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this);
        MaskShaderOptions swimMask = this.getSwimMaskShaderOptions(this.inLiquidFloat(x, y));
        HumanDrawOptions humanDrawOptions = new HumanDrawOptions(level, this.look, false).sprite(sprite).dir(dir).mask(swimMask).light(light).helmet(new InventoryItem("agedchampionhelmet")).chestplate(new InventoryItem("agedchampionchestplate")).boots(new InventoryItem("agedchampiongreaves"));
        if (this.isAttacking) {
            humanDrawOptions.itemAttack(new InventoryItem("agedchampionsword"), null, animProgress, this.attackDir.x, this.attackDir.y);
        }
        final DrawOptions drawOptions = humanDrawOptions.pos(drawX, drawY);
        list.add(new MobDrawable(){

            public void draw(TickManager tickManager) {
                drawOptions.draw();
            }
        });
        this.addShadowDrawables(tileList, level, x, y, light, camera);
    }
}

