/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonminions;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.MobRegistry;
import necesse.engine.util.ComputedObjectValue;
import necesse.engine.util.GameLinkedList;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.WormMobHead;
import necesse.entity.mobs.WormMoveLine;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.PlayerCirclingFollowerCollisionChaserAI;
import necesse.entity.mobs.ai.behaviourTree.util.AIMover;
import necesse.entity.mobs.ai.behaviourTree.util.FlyingAIMover;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.AttackingFollowingWormMobHead;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawables.Drawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameSprite;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import summonerexpansion.summonminions.SandWormBodyMinion;

public class SandWormHeadMinion
extends AttackingFollowingWormMobHead<SandWormBodyMinion, SandWormHeadMinion> {
    public static GameTexture texture;
    public static float lengthPerBodyPart;
    public static float waveLength;
    public static final int totalBodyParts = 4;

    public SandWormHeadMinion() {
        super(10, waveLength, 70.0f, 4, 20.0f, -24.0f);
        this.moveAccuracy = 10;
        this.setSpeed(100.0f);
        this.accelerationMod = 1.0f;
        this.decelerationMod = 1.0f;
        this.collision = new Rectangle(-16, -14, 32, 28);
        this.hitBox = new Rectangle(-20, -16, 40, 32);
        this.selectBox = new Rectangle();
    }

    public GameMessage getLocalization() {
        return new LocalMessage("mob", "sandwormminion");
    }

    protected float getDistToBodyPart(SandWormBodyMinion bodyPart, int index, float lastDistance) {
        return lengthPerBodyPart;
    }

    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new PlayerCirclingFollowerCollisionChaserAI(500, null, 15, -1, 1), (AIMover)new FlyingAIMover());
    }

    protected SandWormBodyMinion createNewBodyPart(int index) {
        SandWormBodyMinion bodyPart = new SandWormBodyMinion();
        bodyPart.spriteY = index == 3 ? 2 : 1;
        bodyPart.collisionDamage = this.summonDamage.modDamage(0.8f);
        bodyPart.modifiers = this.summonModifiers;
        return bodyPart;
    }

    public boolean canBeHit(Attacker attacker) {
        return false;
    }

    protected void playMoveSound() {
    }

    public float getTurnSpeed(float delta) {
        return super.getTurnSpeed(delta) * 1.2f;
    }

    public GameDamage getCollisionDamage(Mob target, boolean fromPacket, ServerClient packetSubmitter) {
        return this.summonDamage;
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), texture, 2, GameRandom.globalRandom.nextInt(6), 32, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
    }

    protected void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        if (this.isVisible()) {
            MobDrawable shoulderDrawable;
            GameLight light = level.getLightLevel((Entity)this);
            int drawX = camera.getDrawX(x) - 32;
            int drawY = camera.getDrawY(y);
            float headAngle = GameMath.fixAngle((float)GameMath.getAngle((Point2D.Float)new Point2D.Float(this.dx, this.dy)));
            final MobDrawable headDrawable = WormMobHead.getAngledDrawable((GameSprite)new GameSprite(texture, 0, 0, 64), null, (GameLight)light, (int)((int)this.height), (float)headAngle, (int)drawX, (int)drawY, (int)96);
            new ComputedObjectValue(null, () -> 0.0);
            ComputedObjectValue shoulderLine = WormMobHead.moveDistance((GameLinkedList.Element)this.moveLines.getFirstElement(), (double)32.0);
            if (shoulderLine.object != null) {
                Point2D.Double shoulderPos = WormMobHead.linePos((ComputedObjectValue)shoulderLine);
                GameLight shoulderLight = level.getLightLevel((int)(shoulderPos.x / 32.0), (int)(shoulderPos.y / 32.0));
                int shoulderDrawX = camera.getDrawX((float)shoulderPos.x) - 32;
                int shoulderDrawY = camera.getDrawY((float)shoulderPos.y);
                float shoulderHeight = this.getWaveHeight(((WormMoveLine)((GameLinkedList.Element)shoulderLine.object).object).movedDist + ((Double)shoulderLine.get()).floatValue());
                float shoulderAngle = GameMath.fixAngle((float)((float)GameMath.getAngle((Point2D.Double)new Point2D.Double((double)this.x - shoulderPos.x, (double)(this.y - this.height) - (shoulderPos.y - (double)shoulderHeight)))));
                shoulderDrawable = WormMobHead.getAngledDrawable((GameSprite)new GameSprite(texture, 0, 1, 64), null, (GameLight)shoulderLight, (int)((int)shoulderHeight), (float)shoulderAngle, (int)shoulderDrawX, (int)shoulderDrawY, (int)96);
            } else {
                shoulderDrawable = null;
            }
            topList.add((Drawable)new MobDrawable(){

                public void draw(TickManager tickManager) {
                    if (shoulderDrawable != null) {
                        shoulderDrawable.draw(tickManager);
                    }
                    headDrawable.draw(tickManager);
                }
            });
            this.addShadowDrawables(tileList, level, x, y, light, camera);
        }
    }

    protected TextureDrawOptions getShadowDrawOptions(int x, int y, GameLight light, GameCamera camera) {
        GameTexture shadowTexture = MobRegistry.Textures.sandWorm_shadow;
        int drawX = camera.getDrawX(x) - shadowTexture.getWidth() / 2;
        int drawY = camera.getDrawY(y) - shadowTexture.getHeight() / 2;
        return shadowTexture.initDraw().light(light).pos(drawX, drawY += this.getBobbing(x, y));
    }

    static {
        lengthPerBodyPart = 32.0f;
        waveLength = 350.0f;
    }
}

