/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonminions;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.gameNetworkData.GNDItem;
import necesse.engine.network.gameNetworkData.GNDItemGameDamage;
import necesse.engine.registries.MobRegistry;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.ToolItemMobAbilityEvent;
import necesse.entity.mobs.AttackAnimMob;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.PlayerFollowerCollisionChaserAI;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.AttackingFollowingMob;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.gfx.GameHair;
import necesse.gfx.GameResources;
import necesse.gfx.GameSkin;
import necesse.gfx.HumanGender;
import necesse.gfx.HumanLook;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.human.HumanDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.armorItem.cosmetics.misc.ShirtArmorItem;
import necesse.inventory.item.armorItem.cosmetics.misc.ShoesArmorItem;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class RuneMeleeMinion
extends AttackingFollowingMob {
    public HumanLook look = new HumanLook();
    public boolean shouldResetFacingPos;
    public float facingBuffer;
    public InventoryItem helmet;
    public InventoryItem chest;
    public InventoryItem boots;
    public Point baseTile;
    public int lookSeed;

    public RuneMeleeMinion() {
        super(10);
        this.setSpeed(20.0f);
        this.setFriction(3.0f);
        this.getLookSeed();
        this.collision = new Rectangle(-10, -7, 20, 14);
        this.hitBox = new Rectangle(-14, -12, 28, 24);
        this.selectBox = new Rectangle();
        this.swimMaskMove = 16;
        this.swimMaskOffset = -2;
        this.swimSinkOffset = -4;
        this.attackAnimTime = 300;
        this.attackCooldown = 700;
    }

    public void addSaveData(SaveData save) {
        super.addSaveData(save);
        save.addInt("lookSeed", this.lookSeed);
        save.addPoint("baseTile", this.baseTile);
    }

    public void applyLoadData(LoadData save) {
        super.applyLoadData(save);
        this.lookSeed = save.getInt("lookSeed", this.lookSeed);
        this.baseTile = save.getPoint("baseTile", new Point(this.getTileX(), this.getTileY()), false);
        this.getLookSeed();
        this.updateLook();
    }

    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.lookSeed = reader.getNextInt();
        this.updateLook();
    }

    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        writer.putNextInt(this.lookSeed);
    }

    public void init() {
        super.init();
        if (this.baseTile == null) {
            this.baseTile = new Point(this.getX() / 32, this.getY() / 32);
        }
        this.updateLook();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new PlayerFollowerCollisionChaserAI<RuneMeleeMinion>(500, this.summonDamage, 50, 800, 900, 60){

            public boolean attackTarget(RuneMeleeMinion mob, Mob target) {
                if (RuneMeleeMinion.this.canAttack()) {
                    mob.attack(target.getX(), target.getY(), true);
                    InventoryItem attackItem = new InventoryItem("brutesbattleaxe");
                    attackItem.getGndData().setItem("damage", (GNDItem)new GNDItemGameDamage(RuneMeleeMinion.this.summonDamage));
                    RuneMeleeMinion.this.getLevel().entityManager.addLevelEvent((LevelEvent)new ToolItemMobAbilityEvent((AttackAnimMob)RuneMeleeMinion.this, GameRandom.globalRandom.nextInt(), attackItem, mob.getX(), mob.getY(), RuneMeleeMinion.this.attackAnimTime, RuneMeleeMinion.this.attackAnimTime));
                    return true;
                }
                return false;
            }
        });
    }

    public void getSeededRandomRuneboundBruteGear() {
        GameRandom random = new GameRandom((long)this.lookSeed);
        String helmetID = (String)random.getOneOfWeighted(String.class, new Object[]{40, "runeboundhornhelmet", 40, "runeboundhelmet", 20, "runeboundhood"});
        String chestID = (String)random.getOneOf((Object[])new String[]{"runeboundbackbones", "runeboundleatherchest"});
        this.helmet = new InventoryItem(helmetID);
        this.chest = new InventoryItem(chestID);
        this.boots = new InventoryItem("runeboundboots");
    }

    public void updateLook() {
        GameRandom random = new GameRandom((long)this.lookSeed);
        HumanGender gender = (HumanGender)random.getOneOfWeighted(HumanGender.class, new Object[]{60, HumanGender.MALE, 30, HumanGender.FEMALE, 10, HumanGender.NEUTRAL});
        this.look.setSkin(10);
        this.look.setEyeType(((Integer)random.getOneOf((Object[])new Integer[]{0, 2, 4})).intValue());
        this.look.setEyeColor(random.getIntBetween(0, 10));
        this.look.setHair(GameHair.getRandomHairBasedOnGender((GameRandom)random, (HumanGender)gender));
        if (gender == HumanGender.MALE) {
            this.look.setFacialFeature(((Integer)random.getOneOf((Object[])new Integer[]{1, 3, 4, 6, 7})).intValue());
        }
        this.look.setHairColor(((Integer)random.getOneOf((Object[])new Integer[]{6, 7, 8, 9})).intValue());
        this.getSeededRandomRuneboundBruteGear();
    }

    public void getLookSeed() {
        if (this.lookSeed == 0) {
            this.lookSeed = GameRandom.globalRandom.nextInt();
        }
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        GameSkin gameSkin = this.look.getGameSkin(true);
        for (int i = 0; i < 4; ++i) {
            this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), gameSkin.getBodyTexture(), GameRandom.globalRandom.nextInt(5), 8, 32, this.x, this.y, 10.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 22 - 10;
        int drawY = camera.getDrawY(y) - 44 - 7;
        float animProgress = this.getAttackAnimProgress();
        int dir = this.getDir();
        Point sprite = this.getAnimSprite(x, y, dir);
        boolean inLiquid = this.inLiquid(x, y);
        if (inLiquid) {
            sprite.x = 0;
        }
        drawY += this.getBobbing(x, y);
        drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this);
        MaskShaderOptions swimMask = this.getSwimMaskShaderOptions(this.inLiquidFloat(x, y));
        HumanDrawOptions humanOptions = new HumanDrawOptions(level, this.look, false).sprite(sprite).mask(swimMask).dir(dir).light(light);
        if (inLiquid) {
            humanOptions.armSprite(2);
            humanOptions.mask(MobRegistry.Textures.runeboundboat_mask[sprite.y % 4], 0, -7);
        }
        if (this.helmet != null) {
            humanOptions.helmet(this.helmet);
        }
        if (this.chest != null) {
            humanOptions.chestplate(this.chest);
        } else {
            humanOptions.chestplate(ShirtArmorItem.addColorData((InventoryItem)new InventoryItem("shirt"), (Color)this.look.getShirtColor()));
        }
        if (this.boots != null) {
            humanOptions.boots(this.boots);
        } else {
            humanOptions.boots(ShoesArmorItem.addColorData((InventoryItem)new InventoryItem("shoes"), (Color)this.look.getShoesColor()));
        }
        if (this.isAttacking) {
            humanOptions.itemAttack(new InventoryItem("brutesbattleaxe"), null, animProgress, this.attackDir.x, this.attackDir.y);
        }
        DrawOptions drawOptions = humanOptions.pos(drawX, drawY);
        TextureDrawOptionsEnd boat = inLiquid ? MobRegistry.Textures.runeboundBoat.initDraw().sprite(0, sprite.y, 64).light(light).pos(drawX, drawY + 7) : null;
        list.add(new MobDrawable((DrawOptions)boat, drawOptions){
            final /* synthetic */ DrawOptions val$boat;
            final /* synthetic */ DrawOptions val$drawOptions;
            {
                this.val$boat = drawOptions;
                this.val$drawOptions = drawOptions2;
            }

            public void draw(TickManager tickManager) {
                if (this.val$boat != null) {
                    this.val$boat.draw();
                }
                this.val$drawOptions.draw();
            }
        });
        this.addShadowDrawables(tileList, level, x, y, light, camera);
    }

    public void setFacingDir(float deltaX, float deltaY) {
        if (!this.isAttacking && this.facingBuffer <= (float)this.getTime()) {
            super.setFacingDir(deltaX, deltaY);
            this.shouldResetFacingPos = true;
        } else if (this.isAttacking) {
            this.facingBuffer = this.getTime() + 500L;
            if (this.shouldResetFacingPos) {
                super.setFacingDir(deltaX, deltaY);
                this.shouldResetFacingPos = false;
            }
        }
    }

    public void showAttack(int x, int y, int seed, boolean showAllDirections) {
        super.showAttack(x, y, seed, showAllDirections);
        if (this.isClient()) {
            SoundManager.playSound((GameSound)GameResources.swing2, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this));
        }
    }
}

