/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonminions;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.registries.MobRegistry;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.SoundSettings;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.engine.util.GameUtils;
import necesse.entity.Entity;
import necesse.entity.ParticleTypeSwitcher;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ability.EmptyMobAbility;
import necesse.entity.mobs.ability.MobAbility;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.PlayerFollowerChaserAI;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.FlyingAttackingFollowingMob;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.entity.projectile.pathProjectile.StaticJellyfishProjectile;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class PetJellyfishMinion
extends FlyingAttackingFollowingMob {
    public final EmptyMobAbility playBoltSoundAbility;

    public PetJellyfishMinion() {
        super(10);
        this.setSpeed(70.0f);
        this.setFriction(0.5f);
        this.moveAccuracy = 20;
        this.attackCooldown = 400;
        this.collision = new Rectangle(-10, -7, 20, 14);
        this.hitBox = new Rectangle(-12, -14, 24, 24);
        this.selectBox = new Rectangle(-16, -28, 32, 34);
        this.playBoltSoundAbility = (EmptyMobAbility)this.registerAbility((MobAbility)new EmptyMobAbility(){

            protected void run() {
                if (PetJellyfishMinion.this.isClient()) {
                    SoundManager.playSound((GameSound)GameResources.magicbolt2, (SoundEffect)SoundEffect.globalEffect().volume(0.5f).pitch(1.1f));
                }
            }
        });
    }

    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new PlayerFollowerChaserAI<PetJellyfishMinion>(500, 300, false, false, 900, 70){

            public boolean attackTarget(PetJellyfishMinion mob, Mob target) {
                if (PetJellyfishMinion.this.canAttack() && !PetJellyfishMinion.this.isOnGenericCooldown("attackCooldown")) {
                    mob.attack(target.getX(), target.getY(), false);
                    StaticJellyfishProjectile projectile = new StaticJellyfishProjectile(mob.x, mob.y, target.x, target.y, 70.0f, 35.0f, 80.0f, PetJellyfishMinion.this.summonDamage, (Mob)mob);
                    mob.getLevel().entityManager.projectiles.add((Entity)projectile);
                    PetJellyfishMinion.this.startGenericCooldown("attackCooldown", PetJellyfishMinion.this.attackCooldown);
                    return true;
                }
                return false;
            }
        });
    }

    public void clientTick() {
        super.clientTick();
        if (GameRandom.globalRandom.getChance(0.2f)) {
            float particleX = this.x + GameRandom.globalRandom.floatGaussian() * 10.0f;
            float particleY = this.y + GameRandom.globalRandom.floatGaussian() * 10.0f;
            float moveX = GameRandom.globalRandom.floatGaussian() * 10.0f;
            float moveY = GameRandom.globalRandom.floatGaussian() * 10.0f;
            this.getLevel().entityManager.addParticle(particleX, particleY, new ParticleTypeSwitcher(new Particle.GType[]{Particle.GType.COSMETIC, Particle.GType.IMPORTANT_COSMETIC, Particle.GType.COSMETIC}).next()).sprite(GameResources.magicSparkParticles.sprite(GameRandom.globalRandom.nextInt(4), 0, 22)).sizeFades(10, 20).movesFriction(moveX, moveY, 0.8f).color(new Color(95, 205, 228)).givesLight(190.0f, 0.9f).height(24.0f).ignoreLight(true).lifeTime(500);
        }
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 4; ++i) {
            this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), MobRegistry.Textures.staticJellyfish.body, GameRandom.globalRandom.nextInt(4), 3, 32, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    protected SoundSettings getHitDeathSound() {
        return new SoundSettings(GameResources.waterblob);
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(PetJellyfishMinion.getTileCoordinate((int)x), PetJellyfishMinion.getTileCoordinate((int)y)).minLevelCopy(100.0f);
        int drawX = camera.getDrawX(x) - 32;
        int drawY = camera.getDrawY(y) - 60;
        int dir = this.getDir();
        Point sprite = this.getAnimSprite(x, y, dir);
        drawY += (int)(GameUtils.getBobbing((long)this.getTime(), (int)1000) * 5.0f);
        final TextureDrawOptionsEnd drawOptions = MobRegistry.Textures.staticJellyfish.body.initDraw().sprite(sprite.x, sprite.y, 64).light(light).pos(drawX, drawY += level.getTile(PetJellyfishMinion.getTileCoordinate((int)x), PetJellyfishMinion.getTileCoordinate((int)y)).getMobSinkingAmount((Mob)this));
        list.add(new MobDrawable(){

            public void draw(TickManager tickManager) {
                drawOptions.draw();
            }
        });
        TextureDrawOptionsEnd shadow = MobRegistry.Textures.small_shadow.initDraw().light(light).posMiddle(camera.getDrawX(x), camera.getDrawY(y));
        tileList.add(arg_0 -> PetJellyfishMinion.lambda$addDrawables$0((TextureDrawOptions)shadow, arg_0));
    }

    public Point getAnimSprite(int x, int y, int dir) {
        return new Point(GameUtils.getAnim((long)this.getTime(), (int)4, (int)400), 0);
    }

    private static /* synthetic */ void lambda$addDrawables$0(TextureDrawOptions shadow, TickManager tm) {
        shadow.draw();
    }
}

