/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonminions;

import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.registries.MobRegistry;
import necesse.engine.registries.ProjectileRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.entity.Entity;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.PlayerFollowerChaserAI;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.AttackingFollowingMob;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.entity.projectile.Projectile;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class LeafShotColdSentry
extends AttackingFollowingMob {
    public static GameTexture texture;

    public LeafShotColdSentry() {
        super(10);
        this.setSpeed(0.0f);
        this.setFriction(3.0f);
        this.setKnockbackModifier(0.0f);
        this.collision = new Rectangle(-10, -7, 20, 14);
        this.hitBox = new Rectangle(-14, -12, 28, 24);
        this.selectBox = new Rectangle();
    }

    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new PlayerFollowerChaserAI<LeafShotColdSentry>(600, 600, false, false, 90000, 64){

            public boolean attackTarget(LeafShotColdSentry mob, Mob target) {
                if (mob.canAttack()) {
                    mob.attack(target.getX(), target.getY(), false);
                    Projectile projectile = ProjectileRegistry.getProjectile((String)"leafcoldballproj", (Level)mob.getLevel(), (float)mob.x, (float)mob.y, (float)target.x, (float)target.y, (float)120.0f, (int)640, (GameDamage)LeafShotColdSentry.this.summonDamage, (Mob)mob);
                    projectile.setTargetPrediction(target, -20.0f);
                    projectile.moveDist(20.0);
                    mob.getLevel().entityManager.projectiles.add((Entity)projectile);
                    return true;
                }
                return false;
            }
        });
    }

    public void clientTick() {
        super.clientTick();
        if (this.isAttacking) {
            this.getAttackAnimProgress();
        }
    }

    public void serverTick() {
        super.serverTick();
        if (this.isAttacking) {
            this.getAttackAnimProgress();
        }
    }

    public boolean canBePushed(Mob other) {
        return false;
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 4; ++i) {
            this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), texture, 10, i, 32, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        int spriteY;
        float animProgress;
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 32;
        int drawY = camera.getDrawY(y) - 56;
        drawY += this.getBobbing(x, y);
        drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this);
        boolean mirror = false;
        if (this.attackDir != null) {
            animProgress = 0.4f;
            if (Math.abs(this.attackDir.x) - Math.abs(this.attackDir.y) <= animProgress) {
                int n = spriteY = this.attackDir.y < 0.0f ? 0 : 2;
                if (this.attackDir.x < 0.0f) {
                    mirror = true;
                }
            } else {
                spriteY = this.attackDir.x < 0.0f ? 3 : 1;
            }
        } else {
            int dir = this.getDir();
            spriteY = dir != 0 && dir != 1 ? 3 : 1;
        }
        animProgress = this.getAttackAnimProgress();
        int spriteX = this.isAttacking ? 1 + Math.min((int)(animProgress * 4.0f), 3) : 0;
        TextureDrawOptionsEnd body = texture.initDraw().sprite(spriteX, spriteY, 64).mirror(mirror, false).light(light).pos(drawX, drawY);
        list.add(new MobDrawable((DrawOptions)body){
            final /* synthetic */ DrawOptions val$body;
            {
                this.val$body = drawOptions;
            }

            public void draw(TickManager tickManager) {
                this.val$body.draw();
            }
        });
        this.addShadowDrawables(tileList, level, x, y, light, camera);
    }

    protected TextureDrawOptions getShadowDrawOptions(int x, int y, GameLight light, GameCamera camera) {
        GameTexture shadowTexture = MobRegistry.Textures.human_shadow;
        int res = shadowTexture.getHeight();
        int drawX = camera.getDrawX(x) - res / 2;
        int drawY = camera.getDrawY(y) - res / 2;
        drawY += this.getBobbing(x, y);
        return shadowTexture.initDraw().sprite(0, 0, res).light(light).pos(drawX, drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this));
    }

    public void showAttack(int x, int y, int seed, boolean showAllDirections) {
        super.showAttack(x, y, seed, showAllDirections);
        if (this.isClient()) {
            SoundManager.playSound((GameSound)GameResources.flick, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).pitch(1.2f));
        }
    }
}

