/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonminions;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.registries.MobRegistry;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.engine.util.GroundPillar;
import necesse.entity.Entity;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.PlayerFollowerChaserAI;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.AttackingFollowingMob;
import necesse.entity.particle.Particle;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTexture.GameTextureSection;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import summonerexpansion.summonprojs.HorrorSentryProj;

public class HorrorSentry
extends AttackingFollowingMob {
    public static GameTexture texture;
    public int lifeTime = 0;

    public HorrorSentry() {
        super(100);
        this.setSpeed(0.0f);
        this.setFriction(3.0f);
        this.setKnockbackModifier(0.0f);
        this.collision = new Rectangle(-10, -7, 20, 14);
        this.hitBox = new Rectangle(-14, -12, 28, 24);
        this.selectBox = new Rectangle(-14, -23, 28, 32);
    }

    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new PlayerFollowerChaserAI<HorrorSentry>(600, 600, false, false, 90000, 64){

            public boolean attackTarget(HorrorSentry mob, Mob target) {
                if (mob.canAttack()) {
                    mob.attack(target.getX(), target.getY(), false);
                    HorrorSentryProj projectile = new HorrorSentryProj(HorrorSentry.this.getLevel(), (Mob)mob, mob.x, mob.y, target.x, target.y, 75.0f, 512, HorrorSentry.this.summonDamage, 50);
                    projectile.x -= projectile.dx * 20.0f;
                    projectile.y -= projectile.dy * 20.0f;
                    mob.attack((int)(mob.x + projectile.dx * 100.0f), (int)(mob.y + projectile.dy * 100.0f), false);
                    mob.getLevel().entityManager.projectiles.add((Entity)projectile);
                    return true;
                }
                return false;
            }
        });
    }

    public void clientTick() {
        super.clientTick();
        if (this.isAttacking) {
            this.getAttackAnimProgress();
        }
    }

    public void serverTick() {
        super.serverTick();
        ++this.lifeTime;
        if (this.lifeTime >= 6000) {
            this.remove(0.0f, 0.0f, null, true);
        }
        if (this.isAttacking) {
            this.getAttackAnimProgress();
        }
    }

    public boolean canBePushed(Mob other) {
        return false;
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 20; ++i) {
            this.getLevel().entityManager.addParticle(this.x, this.y, Particle.GType.COSMETIC).movesConstantAngle((float)GameRandom.globalRandom.nextInt(360), (float)GameRandom.globalRandom.getIntBetween(5, 20)).color(new Color(10, 10, 10));
        }
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        float animProgress;
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 15;
        int drawY = camera.getDrawY(y) - 26;
        drawY += this.getBobbing(x, y);
        drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this);
        if (this.inLiquid(x, y)) {
            drawY -= 10;
        }
        float wiggle = (animProgress = GameMath.limit((float)this.getAttackAnimProgress(), (float)0.0f, (float)1.0f)) < 0.5f ? animProgress * 2.0f : Math.abs((animProgress - 0.5f) * 2.0f - 1.0f);
        int pixelChange = (int)(wiggle * 5.0f);
        TextureDrawOptionsEnd body = texture.initDraw().sprite(0, 0, 32).size(32 - pixelChange * 2, 32 - pixelChange).light(light).pos(drawX + pixelChange, drawY + pixelChange);
        list.add(new MobDrawable((DrawOptions)body){
            final /* synthetic */ DrawOptions val$body;
            {
                this.val$body = drawOptions;
            }

            public void draw(TickManager tickManager) {
                this.val$body.draw();
            }
        });
        if (this.inLiquid(x, y)) {
            y -= 10;
        }
        this.addShadowDrawables(tileList, level, x, y, light, camera);
    }

    protected TextureDrawOptions getShadowDrawOptions(int x, int y, GameLight light, GameCamera camera) {
        GameTexture shadowTexture = MobRegistry.Textures.human_shadow;
        int res = shadowTexture.getHeight();
        int drawX = camera.getDrawX(x) - res / 2;
        int drawY = camera.getDrawY(y) - res / 2;
        drawY += this.getBobbing(x, y);
        return shadowTexture.initDraw().sprite(0, 0, res).light(light).pos(drawX, drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this));
    }

    public static class HorrorPillar
    extends GroundPillar {
        public GameTextureSection texture2;
        public boolean mirror = GameRandom.globalRandom.nextBoolean();

        public HorrorPillar(int x, int y, double spawnDistance, long spawnTime) {
            super(x, y, spawnDistance, spawnTime);
            this.texture2 = MobRegistry.Textures.cryoQueen == null ? null : (GameTextureSection)GameRandom.globalRandom.getOneOf((Object[])new GameTextureSection[]{new GameTextureSection(texture).sprite(1, 0, 32), new GameTextureSection(texture).sprite(2, 0, 32), new GameTextureSection(texture).sprite(3, 0, 32), new GameTextureSection(texture).sprite(4, 0, 32), new GameTextureSection(texture).sprite(5, 0, 32)});
            this.behaviour = new GroundPillar.TimedBehaviour(300, 200, 800);
        }

        public DrawOptions getDrawOptions(Level level, long currentTime, double distanceMoved, GameCamera camera) {
            GameLight light = level.getLightLevel(this.x / 32, this.y / 32);
            int drawX = camera.getDrawX(this.x);
            int drawY = camera.getDrawY(this.y);
            double height = this.getHeight(currentTime, distanceMoved);
            int endY = (int)(height * (double)this.texture2.getHeight());
            return this.texture2.section(0, this.texture2.getWidth(), 0, endY).initDraw().mirror(this.mirror, false).light(light).pos(drawX - this.texture2.getWidth() / 2, drawY - endY);
        }
    }
}

