/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonminions;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.CrystallizeShatterEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.PlayerFollowerCollisionChaserAI;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffManager;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.AttackingFollowingMob;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class GolemAmethystMinion
extends AttackingFollowingMob {
    public static GameTexture texture;

    public GolemAmethystMinion() {
        super(10);
        this.setSpeed(25.0f);
        this.setFriction(1.0f);
        this.collision = new Rectangle(-10, -7, 20, 14);
        this.hitBox = new Rectangle(-14, -12, 28, 24);
        this.selectBox = new Rectangle();
        this.swimMaskMove = 32;
        this.swimMaskOffset = -6;
        this.swimSinkOffset = -4;
    }

    public GameDamage getCollisionDamage(Mob target, boolean fromPacket, ServerClient packetSubmitter) {
        return this.summonDamage;
    }

    public void handleCollisionHit(Mob target, GameDamage damage, int knockback) {
        Mob owner = this.getAttackOwner();
        if (this.getLevel().isServer() && owner != null && target != null) {
            BuffManager attackerBM = owner.buffManager;
            float thresholdMod = ((Float)attackerBM.getModifier(BuffModifiers.SUMMON_CRIT_CHANCE)).floatValue();
            float crystallizeMod = ((Float)attackerBM.getModifier(BuffModifiers.CRIT_DAMAGE)).floatValue() + ((Float)attackerBM.getModifier(BuffModifiers.SUMMON_CRIT_CHANCE)).floatValue();
            int stackThreshold = (int)GameMath.limit((float)(10.0f - 7.0f * thresholdMod), (float)3.0f, (float)10.0f);
            float crystallizeDamageMultiplier = GameMath.limit((float)crystallizeMod, (float)2.0f, (float)stackThreshold);
            Buff crystallizeBuff = BuffRegistry.Debuffs.CRYSTALLIZE_BUFF;
            ActiveBuff ab = new ActiveBuff(crystallizeBuff, target, 2000, (Attacker)this);
            target.buffManager.addBuff(ab, true);
            ActiveBuff buff = target.buffManager.getBuff(crystallizeBuff);
            if (buff != null && buff.getStacks() >= stackThreshold) {
                this.getLevel().entityManager.events.add((LevelEvent)new CrystallizeShatterEvent(target, CrystallizeShatterEvent.ParticleType.AMETHYST));
                target.buffManager.removeBuff(crystallizeBuff, true);
                GameDamage finalDamage = this.summonDamage.modDamage(crystallizeDamageMultiplier);
                target.isServerHit(finalDamage, 0.0f, 0.0f, 0.0f, (Attacker)this);
            }
        }
    }

    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new PlayerFollowerCollisionChaserAI(600, this.summonDamage, 120, 600, 900, 80));
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 4; ++i) {
            this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), texture, GameRandom.globalRandom.nextInt(5), 8, 32, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 22 - 10;
        int drawY = camera.getDrawY(y) - 44 - 7 - 6;
        int dir = this.getDir();
        Point sprite = this.getAnimSprite(x, y, dir);
        drawY += this.getBobbing(x, y);
        drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this);
        if (this.isAttacking) {
            sprite.x = 0;
        }
        final MaskShaderOptions swimMask = this.getSwimMaskShaderOptions(this.inLiquidFloat(x, y));
        TextureDrawOptionsEnd drawOptions = texture.initDraw().sprite(sprite.x, sprite.y, 64).addMaskShader(swimMask).light(light.minLevelCopy(100.0f)).pos(drawX, drawY);
        list.add(new MobDrawable((DrawOptions)drawOptions){
            final /* synthetic */ DrawOptions val$drawOptions;
            {
                this.val$drawOptions = drawOptions;
            }

            public void draw(TickManager tickManager) {
                swimMask.use();
                this.val$drawOptions.draw();
                swimMask.stop();
            }
        });
        this.addShadowDrawables(tileList, level, x, y, light, camera);
    }
}

