/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonminions;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.gameNetworkData.GNDItem;
import necesse.engine.network.gameNetworkData.GNDItemGameDamage;
import necesse.engine.registries.MobRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.ToolItemMobAbilityEvent;
import necesse.entity.mobs.AttackAnimMob;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.PlayerFollowerCollisionChaserAI;
import necesse.entity.mobs.friendly.BoarMob;
import necesse.entity.mobs.friendly.ChickenMob;
import necesse.entity.mobs.friendly.PigMob;
import necesse.entity.mobs.friendly.RoosterMob;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.AttackingFollowingMob;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.gfx.GameHair;
import necesse.gfx.GameResources;
import necesse.gfx.GameSkin;
import necesse.gfx.HumanGender;
import necesse.gfx.HumanLook;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.human.HumanDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.inventory.InventoryItem;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class FarmerMinion
extends AttackingFollowingMob {
    public boolean shouldResetFacingPos;
    public float facingBuffer;
    protected HumanLook look;
    protected int lookSeed;

    public FarmerMinion() {
        super(10);
        this.setSpeed(50.0f);
        this.setFriction(3.0f);
        this.collision = new Rectangle(-10, -7, 20, 14);
        this.hitBox = new Rectangle(-14, -12, 28, 24);
        this.selectBox = new Rectangle();
        this.swimMaskMove = 16;
        this.swimMaskOffset = -2;
        this.swimSinkOffset = -4;
        this.attackAnimTime = 600;
        this.attackCooldown = 900;
        this.look = new HumanLook();
        this.getLookSeed();
        this.updateLook();
    }

    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        writer.putNextInt(this.lookSeed);
    }

    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.lookSeed = reader.getNextInt();
        this.updateLook();
    }

    public void init() {
        super.init();
        this.updateLook();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new PlayerFollowerCollisionChaserAI<FarmerMinion>(500, this.summonDamage, 50, 800, 900, 60){

            public boolean attackTarget(FarmerMinion mob, Mob target) {
                if (FarmerMinion.this.canAttack()) {
                    mob.attack(target.getX(), target.getY(), true);
                    InventoryItem attackItem = new InventoryItem("coppersword");
                    attackItem.getGndData().setItem("damage", (GNDItem)new GNDItemGameDamage(FarmerMinion.this.summonDamage));
                    FarmerMinion.this.getLevel().entityManager.addLevelEvent((LevelEvent)new ToolItemMobAbilityEvent((AttackAnimMob)FarmerMinion.this, GameRandom.globalRandom.nextInt(), attackItem, mob.getX(), mob.getY(), FarmerMinion.this.attackAnimTime, FarmerMinion.this.attackAnimTime));
                    if (GameRandom.globalRandom.nextInt(100) <= 10) {
                        FarmerMinion.this.getLevel().entityManager.pickups.add((Entity)new InventoryItem("wheat").getPickupEntity(FarmerMinion.this.getLevel(), FarmerMinion.this.x, FarmerMinion.this.y));
                    }
                    if (GameRandom.globalRandom.nextInt(100) <= 2) {
                        if (GameRandom.globalRandom.nextInt(100) <= 20) {
                            mob.getLevel().entityManager.addMob((Mob)new RoosterMob(), FarmerMinion.this.x, FarmerMinion.this.y);
                        } else if (GameRandom.globalRandom.nextInt(100) <= 20) {
                            mob.getLevel().entityManager.addMob((Mob)new BoarMob(), FarmerMinion.this.x, FarmerMinion.this.y);
                        } else if (GameRandom.globalRandom.nextInt(100) <= 20) {
                            mob.getLevel().entityManager.addMob((Mob)new PigMob(), FarmerMinion.this.x, FarmerMinion.this.y);
                        } else {
                            mob.getLevel().entityManager.addMob((Mob)new ChickenMob(), FarmerMinion.this.x, FarmerMinion.this.y);
                        }
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public void updateLook() {
        if (this.lookSeed == 0) {
            this.lookSeed = GameRandom.globalRandom.nextInt();
        }
        GameRandom random = new GameRandom((long)this.lookSeed);
        HumanGender gender = (HumanGender)random.getOneOfWeighted(HumanGender.class, new Object[]{20, HumanGender.MALE, 20, HumanGender.FEMALE, 20, HumanGender.NEUTRAL});
        this.look.setSkin(((Integer)random.getOneOf((Object[])new Integer[]{0, 1, 2, 3, 13, 14, 17, 18})).intValue());
        this.look.setEyeType(random.getIntBetween(0, 11));
        this.look.setEyeColor(random.getIntBetween(0, 11));
        this.look.setHair(GameHair.getRandomHairBasedOnGender((GameRandom)random, (HumanGender)gender));
        if (gender == HumanGender.MALE) {
            this.look.setFacialFeature(random.getIntBetween(1, 7));
        }
        this.look.setHairColor(random.getIntBetween(1, 25));
    }

    public void getLookSeed() {
        if (this.lookSeed == 0) {
            this.lookSeed = GameRandom.globalRandom.nextInt();
        }
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        GameSkin gameSkin = this.look.getGameSkin(true);
        for (int i = 0; i < 4; ++i) {
            this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), gameSkin.getBodyTexture(), GameRandom.globalRandom.nextInt(5), 8, 32, this.x, this.y, 10.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 22 - 10;
        int drawY = camera.getDrawY(y) - 44 - 7;
        int dir = this.getDir();
        float animProgress = this.getAttackAnimProgress();
        Point sprite = this.getAnimSprite(x, y, dir);
        boolean inLiquid = this.inLiquid(x, y);
        if (inLiquid) {
            sprite.x = 0;
        }
        drawY += this.getBobbing(x, y);
        drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this);
        MaskShaderOptions swimMask = this.getSwimMaskShaderOptions(this.inLiquidFloat(x, y));
        HumanDrawOptions humanDrawOptions = new HumanDrawOptions(level, this.look, false).sprite(sprite).dir(dir).mask(swimMask).light(light).helmet(new InventoryItem("farmerhat")).chestplate(new InventoryItem("farmershirt")).boots(new InventoryItem("farmershoes"));
        if (this.isAttacking) {
            humanDrawOptions.itemAttack(new InventoryItem("copperpitchfork"), null, animProgress, this.attackDir.x, this.attackDir.y);
        }
        if (inLiquid) {
            humanDrawOptions.armSprite(2);
            humanDrawOptions.mask(MobRegistry.Textures.boat_mask[sprite.y % 4], 0, -7);
        }
        DrawOptions drawOptions = humanDrawOptions.pos(drawX, drawY);
        TextureDrawOptionsEnd boat = inLiquid ? MobRegistry.Textures.steelBoat.initDraw().sprite(0, sprite.y, 64).light(light).pos(drawX, drawY + 7) : null;
        list.add(new MobDrawable((DrawOptions)boat, drawOptions){
            final /* synthetic */ DrawOptions val$boat;
            final /* synthetic */ DrawOptions val$drawOptions;
            {
                this.val$boat = drawOptions;
                this.val$drawOptions = drawOptions2;
            }

            public void draw(TickManager tickManager) {
                if (this.val$boat != null) {
                    this.val$boat.draw();
                }
                this.val$drawOptions.draw();
            }
        });
        this.addShadowDrawables(tileList, level, x, y, light, camera);
    }

    public void setFacingDir(float deltaX, float deltaY) {
        if (!this.isAttacking && this.facingBuffer <= (float)this.getTime()) {
            super.setFacingDir(deltaX, deltaY);
            this.shouldResetFacingPos = true;
        } else if (this.isAttacking) {
            this.facingBuffer = this.getTime() + 500L;
            if (this.shouldResetFacingPos) {
                super.setFacingDir(deltaX, deltaY);
                this.shouldResetFacingPos = false;
            }
        }
    }

    public void showAttack(int x, int y, int seed, boolean showAllDirections) {
        super.showAttack(x, y, seed, showAllDirections);
        if (this.isClient()) {
            SoundManager.playSound((GameSound)GameResources.swing2, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this));
        }
    }
}

