/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonminions;

import java.awt.Rectangle;
import java.util.List;
import necesse.engine.DifficultyBasedGetter;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.MaxHealthGetter;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.PlayerFlyingFollowerCollisionChaserAI;
import necesse.entity.mobs.ai.behaviourTree.util.AIMover;
import necesse.entity.mobs.ai.behaviourTree.util.FlyingAIMover;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.FlyingAttackingFollowingMob;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class BookRunicShieldMinion
extends FlyingAttackingFollowingMob {
    public static GameTexture texture;
    public static MaxHealthGetter MAX_HEALTH;

    public BookRunicShieldMinion() {
        super(10);
        this.difficultyChanges.setMaxHealth((DifficultyBasedGetter)MAX_HEALTH);
        this.setArmor(10);
        this.setSpeed(100.0f);
        this.setFriction(2.0f);
        this.isStatic = false;
        this.moveAccuracy = 5;
        this.collision = new Rectangle(-30, -30, 60, 60);
        this.hitBox = new Rectangle(-30, -30, 60, 60);
        this.selectBox = new Rectangle();
    }

    public GameDamage getCollisionDamage(Mob target, boolean fromPacket, ServerClient packetSubmitter) {
        return this.summonDamage;
    }

    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new PlayerFlyingFollowerCollisionChaserAI(0, this.summonDamage, 105, 500, 1000, 64), (AIMover)new FlyingAIMover());
    }

    public int getCollisionKnockback(Mob target) {
        return 105;
    }

    public void handleCollisionHit(Mob target, GameDamage damage, int knockback) {
        Mob owner = this.getAttackOwner();
        if (owner != null && target != null) {
            target.isServerHit(damage, target.x - owner.x, target.y - owner.y, (float)knockback, (Attacker)this);
            this.collisionHitCooldowns.startCooldown(target);
            ActiveBuff buff = this.getAttackOwner().buffManager.hasBuff("runicsetbonus") ? new ActiveBuff(BuffRegistry.getBuff((String)"runicshieldbuff"), target, 60.0f, (Attacker)this) : new ActiveBuff(BuffRegistry.getBuff((String)"runicshieldbuff"), target, 30.0f, (Attacker)this);
            this.getFollowingItemAttacker().addBuff(buff, true);
        }
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 30; ++i) {
            GameRandom random = GameRandom.globalRandom;
            this.getLevel().entityManager.addParticle(this.x, this.y, Particle.GType.COSMETIC).sprite(GameResources.particles.sprite(random.nextInt(4), 0, 18, 24)).movesConstantAngle((float)random.nextInt(360), (float)random.getIntBetween(5, 20)).sizeFades(24, 12);
        }
    }

    public void playDeathSound() {
        SoundManager.playSound((GameSound)GameResources.shatter1, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(0.5f));
    }

    protected void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 16;
        int drawY = camera.getDrawY(y) - 10;
        TextureDrawOptionsEnd body = texture.initDraw().sprite(0, 0, 32).light(light).pos(drawX, drawY);
        topList.add(arg_0 -> BookRunicShieldMinion.lambda$addDrawables$0((DrawOptions)body, arg_0));
        TextureDrawOptionsEnd shadow = MobRegistry.Textures.rubyShield_shadow.initDraw().sprite(0, 0, 32).light(light).pos(drawX, drawY + 10);
        tileList.add(arg_0 -> BookRunicShieldMinion.lambda$addDrawables$1((DrawOptions)shadow, arg_0));
    }

    private static /* synthetic */ void lambda$addDrawables$1(DrawOptions shadow, TickManager tm) {
        shadow.draw();
    }

    private static /* synthetic */ void lambda$addDrawables$0(DrawOptions body, TickManager tm) {
        body.draw();
    }

    static {
        MAX_HEALTH = new MaxHealthGetter(100, 150, 200, 250, 300);
    }
}

