/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonminions;

import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.engine.util.GameUtils;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.PlayerFollowerCollisionChaserAI;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.AttackingFollowingJumpingMob;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class BookMagmaSlimeMinion
extends AttackingFollowingJumpingMob {
    public int lifeTime = 12000;
    public static GameTexture texture;

    public BookMagmaSlimeMinion() {
        super(10);
        this.setSpeed(60.0f);
        this.setFriction(2.0f);
        this.jumpStats.setJumpAnimationTime(250);
        this.jumpStats.setJumpStrength(150.0f);
        this.jumpStats.setJumpCooldown(50);
        this.jumpStats.jumpStrengthUseSpeedMod = false;
        this.collision = new Rectangle(-8, -6, 16, 12);
        this.hitBox = new Rectangle(-12, -14, 24, 24);
        this.selectBox = new Rectangle();
        this.swimMaskMove = 8;
        this.swimMaskOffset = -2;
        this.swimSinkOffset = 0;
    }

    public int getCollisionKnockback(Mob target) {
        return 30;
    }

    public GameDamage getCollisionDamage(Mob target, boolean fromPacket, ServerClient packetSubmitter) {
        return this.summonDamage;
    }

    public void handleCollisionHit(Mob target, GameDamage damage, int knockback) {
        Mob owner = this.getAttackOwner();
        if (owner != null && target != null) {
            target.isServerHit(damage, target.x - owner.x, target.y - owner.y, (float)knockback, (Attacker)this);
            this.collisionHitCooldowns.startCooldown(target);
            if (target.buffManager.hasBuff(BuffRegistry.Debuffs.ABLAZE)) {
                target.addBuff(new ActiveBuff(BuffRegistry.Debuffs.ABLAZE, target, 216000.0f, (Attacker)owner), true);
            }
            if (target.buffManager.hasBuff(BuffRegistry.Debuffs.ON_FIRE)) {
                target.addBuff(new ActiveBuff(BuffRegistry.Debuffs.ON_FIRE, target, 216000.0f, (Attacker)owner), true);
            }
            if (target.buffManager.hasBuff(BuffRegistry.Debuffs.FROSTBURN)) {
                target.addBuff(new ActiveBuff(BuffRegistry.Debuffs.FROSTBURN, target, 216000.0f, (Attacker)owner), true);
            }
            if (target.buffManager.hasBuff(BuffRegistry.getBuff((String)"lampgolddebuff"))) {
                target.addBuff(new ActiveBuff(BuffRegistry.getBuff((String)"lampgolddebuff"), target, 216000.0f, (Attacker)owner), true);
            }
            if (target.buffManager.hasBuff(BuffRegistry.getBuff((String)"lamptungstendebuff"))) {
                target.addBuff(new ActiveBuff(BuffRegistry.getBuff((String)"lamptungstendebuff"), target, 216000.0f, (Attacker)owner), true);
            }
            if (target.buffManager.hasBuff(BuffRegistry.getBuff((String)"lampcastledebuff"))) {
                target.addBuff(new ActiveBuff(BuffRegistry.getBuff((String)"lampcastledebuff"), target, 216000.0f, (Attacker)owner), true);
            }
            if (target.buffManager.hasBuff(BuffRegistry.getBuff((String)"lampdungeondebuff"))) {
                target.addBuff(new ActiveBuff(BuffRegistry.getBuff((String)"lampdungeondebuff"), target, 216000.0f, (Attacker)owner), true);
            }
            this.remove(0.0f, 0.0f, null, true);
        }
    }

    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new PlayerFollowerCollisionChaserAI(140, (GameDamage)null, 30, 500, 200, 80));
    }

    public void serverTick() {
        super.serverTick();
        --this.lifeTime;
        if (this.lifeTime <= 0) {
            this.remove(0.0f, 0.0f, null, true);
        }
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 4; ++i) {
            this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), texture, i, 4, 32, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    public void playDeathSound() {
        float pitch = ((Float)GameRandom.globalRandom.getOneOf((Object[])new Float[]{Float.valueOf(0.95f), Float.valueOf(1.0f), Float.valueOf(1.05f)})).floatValue();
        SoundManager.playSound((GameSound)GameResources.npcdeath, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(0.1f).pitch(pitch));
    }

    protected void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 32;
        int drawY = camera.getDrawY(y) - 26 - 32;
        boolean inLiquid = this.inLiquid(x, y);
        int spriteX = inLiquid ? GameUtils.getAnim((long)this.getWorldEntity().getTime(), (int)2, (int)1000) : this.getJumpAnimationFrame(6);
        drawY += this.getBobbing(x, y);
        final MaskShaderOptions swimMask = this.getSwimMaskShaderOptions(this.inLiquidFloat(x, y));
        TextureDrawOptionsEnd options = texture.initDraw().sprite(spriteX, inLiquid ? 1 : 0, 64).addMaskShader(swimMask).light(light).pos(drawX, drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this));
        list.add(new MobDrawable((DrawOptions)options){
            final /* synthetic */ DrawOptions val$options;
            {
                this.val$options = drawOptions;
            }

            public void draw(TickManager tickManager) {
                swimMask.use();
                this.val$options.draw();
                swimMask.stop();
            }
        });
        TextureDrawOptionsEnd shadow = MobRegistry.Textures.pouncingSlime_shadow.initDraw().sprite(spriteX, 0, 64).light(light).pos(drawX, drawY);
        tileList.add(arg_0 -> BookMagmaSlimeMinion.lambda$addDrawables$0((TextureDrawOptions)shadow, arg_0));
    }

    private static /* synthetic */ void lambda$addDrawables$0(TextureDrawOptions shadow, TickManager tm) {
        shadow.draw();
    }
}

