/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonminions;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.registries.MobRegistry;
import necesse.engine.registries.ProjectileRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.PlayerFollowerChaserAI;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.AttackingFollowingMob;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.entity.projectile.Projectile;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.human.HumanDrawOptions;
import necesse.gfx.drawOptions.itemAttack.HumanAttackDrawOptions;
import necesse.gfx.drawOptions.itemAttack.ItemAttackDrawOptions;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class BookFrozenMinion
extends AttackingFollowingMob {
    public int throwLife = 0;
    public boolean hasHair;

    public BookFrozenMinion() {
        super(10);
        this.setSpeed(35.0f);
        this.setFriction(3.0f);
        this.collision = new Rectangle(-10, -7, 20, 14);
        this.hitBox = new Rectangle(-14, -12, 28, 24);
        this.selectBox = new Rectangle();
        this.swimMaskMove = 14;
        this.swimMaskOffset = -2;
        this.swimSinkOffset = -4;
        this.attackCooldown = 750;
        this.attackAnimTime = 250;
    }

    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new PlayerFollowerChaserAI<BookFrozenMinion>(400, 300, false, false, 800, 100){

            public boolean attackTarget(BookFrozenMinion mob, Mob target) {
                if (mob.canAttack() && BookFrozenMinion.this.getAttackOwner().buffManager.hasBuff("frostcrownsetbonus")) {
                    mob.attack(target.getX(), target.getY(), false);
                    Projectile projectile = ProjectileRegistry.getProjectile((String)"iceminionjavelinproj", (Level)mob.getLevel(), (float)mob.x, (float)mob.y, (float)target.x, (float)target.y, (float)120.0f, (int)600, (GameDamage)BookFrozenMinion.this.summonDamage.modFinalMultiplier(1.2f), (Mob)mob);
                    projectile.setTargetPrediction(target, -20.0f);
                    projectile.moveDist(120.0);
                    mob.getLevel().entityManager.projectiles.add((Entity)projectile);
                    if (GameRandom.globalRandom.nextInt(2) == 0) {
                        ++BookFrozenMinion.this.throwLife;
                    }
                    return true;
                }
                if (mob.canAttack()) {
                    mob.attack(target.getX(), target.getY(), false);
                    Projectile projectile = ProjectileRegistry.getProjectile((String)"iceminionjavelinproj", (Level)mob.getLevel(), (float)mob.x, (float)mob.y, (float)target.x, (float)target.y, (float)80.0f, (int)480, (GameDamage)BookFrozenMinion.this.summonDamage, (Mob)mob);
                    projectile.setTargetPrediction(target, -20.0f);
                    projectile.moveDist(80.0);
                    mob.getLevel().entityManager.projectiles.add((Entity)projectile);
                    ++BookFrozenMinion.this.throwLife;
                    return true;
                }
                return false;
            }
        });
        this.hasHair = new GameRandom((long)this.getUniqueID()).nextSeeded(51).nextBoolean();
    }

    public void serverTick() {
        super.serverTick();
        if (this.throwLife >= 10) {
            this.remove(0.0f, 0.0f, null, true);
        }
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 4; ++i) {
            this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), MobRegistry.Textures.frozenDwarf.body, GameRandom.globalRandom.nextInt(5), 8, 32, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(BookFrozenMinion.getTileCoordinate((int)x), BookFrozenMinion.getTileCoordinate((int)y));
        int drawX = camera.getDrawX(x) - 22 - 10;
        int drawY = camera.getDrawY(y) - 44 - 7;
        int dir = this.getDir();
        Point sprite = this.getAnimSprite(x, y, dir);
        drawY += this.getBobbing(x, y);
        drawY += level.getTile(BookFrozenMinion.getTileCoordinate((int)x), BookFrozenMinion.getTileCoordinate((int)y)).getMobSinkingAmount((Mob)this);
        float animProgress = this.getAttackAnimProgress();
        MaskShaderOptions swimMask = this.getSwimMaskShaderOptions(this.inLiquidFloat(x, y));
        HumanDrawOptions humanDrawOptions = new HumanDrawOptions(level, MobRegistry.Textures.frozenDwarf).hairTexture((GameTexture)(this.hasHair ? MobRegistry.Textures.frozenDwarfHair : null)).sprite(sprite).dir(dir).mask(swimMask).light(light).attackOffsets(dir == 3 ? 36 : 28, 23, 10, 15, 12, 4, 12);
        if (this.isAttacking) {
            ItemAttackDrawOptions attackOptions = ItemAttackDrawOptions.start((int)dir).itemSprite(MobRegistry.Textures.frozenDwarf.body, 0, 9, 32).itemRotatePoint(4, 4).itemEnd().armSprite(MobRegistry.Textures.frozenDwarf.body, 0, 8, 32).swingRotation(animProgress).light(light);
            humanDrawOptions.attackAnim((HumanAttackDrawOptions)attackOptions, animProgress);
        }
        final DrawOptions drawOptions = humanDrawOptions.pos(drawX, drawY);
        list.add(new MobDrawable(){

            public void draw(TickManager tickManager) {
                drawOptions.draw();
            }
        });
        this.addShadowDrawables(tileList, level, x, y, light, camera);
    }

    public int getRockSpeed() {
        return 20;
    }

    public void showAttack(int x, int y, int seed, boolean showAllDirections) {
        super.showAttack(x, y, seed, showAllDirections);
        if (this.isClient()) {
            SoundManager.playSound((GameSound)GameResources.swing1, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(0.5f));
        }
    }
}

