/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonminions;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.PlayerFollowerCollisionChaserAI;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.AttackingFollowingMob;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class BearMinion
extends AttackingFollowingMob {
    public static GameTexture texture;

    public BearMinion() {
        super(10);
        this.setSpeed(40.0f);
        this.setFriction(3.0f);
        this.collision = new Rectangle(-10, -7, 20, 14);
        this.hitBox = new Rectangle(-20, -16, 40, 32);
        this.selectBox = new Rectangle();
        this.swimMaskMove = 32;
        this.swimMaskOffset = -55;
        this.swimSinkOffset = -8;
        this.prioritizeVerticalDir = false;
    }

    public GameDamage getCollisionDamage(Mob target, boolean fromPacket, ServerClient packetSubmitter) {
        if (this.getAttackOwner().buffManager.hasBuff("leathersummonersetbonus")) {
            return this.summonDamage.modFinalMultiplier(1.2f);
        }
        return this.summonDamage;
    }

    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new PlayerFollowerCollisionChaserAI(500, this.summonDamage, 30, 800, 640, 100));
    }

    public void handleCollisionHit(Mob target, GameDamage damage, int knockback) {
        Mob owner = this.getAttackOwner();
        if (owner != null && target != null) {
            ActiveBuff buff = this.getAttackOwner().buffManager.hasBuff("leathersummonersetbonus") ? new ActiveBuff(BuffRegistry.getBuff((String)"bleedingdebuff"), target, 20.0f, (Attacker)this) : new ActiveBuff(BuffRegistry.getBuff((String)"bleedingdebuff"), target, 10.0f, (Attacker)this);
            target.addBuff(buff, true);
        }
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 4; ++i) {
            this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), texture, i, 16, 32, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 64;
        int drawY = camera.getDrawY(y) - 128 + 36;
        int dir = this.getDir();
        Point sprite = this.getAnimSprite(x, y, dir);
        drawY += this.getBobbing(x, y);
        final MaskShaderOptions swimMask = this.getSwimMaskShaderOptions(this.inLiquidFloat(x, y));
        TextureDrawOptionsEnd options = texture.initDraw().sprite(sprite.x, sprite.y, 128).addMaskShader(swimMask).light(light).pos(drawX, drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this));
        list.add(new MobDrawable((DrawOptions)options){
            final /* synthetic */ DrawOptions val$options;
            {
                this.val$options = drawOptions;
            }

            public void draw(TickManager tickManager) {
                swimMask.use();
                this.val$options.draw();
                swimMask.stop();
            }
        });
        this.addShadowDrawables(tileList, level, x, y, light, camera);
    }

    protected TextureDrawOptions getShadowDrawOptions(int x, int y, GameLight light, GameCamera camera) {
        GameTexture shadowTexture = MobRegistry.Textures.grizzlyBear_shadow;
        int drawX = camera.getDrawX(x) - 64;
        int drawY = camera.getDrawY(y) - 128 + 36;
        return shadowTexture.initDraw().sprite(0, this.getDir(), 128).light(light).pos(drawX, drawY += this.getBobbing(x, y));
    }

    public int getRockSpeed() {
        return 10;
    }
}

