/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonarmorsetbonus;

import java.awt.Color;
import java.util.LinkedList;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.GameMessageBuilder;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.modifiers.ModifierContainer;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.armorBuffs.setBonusBuffs.SetBonusBuff;
import necesse.entity.mobs.gameDamageType.DamageType;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.inventory.item.DoubleItemStatTip;
import necesse.inventory.item.ItemStatTip;
import necesse.inventory.item.upgradeUtils.FloatUpgradeValue;
import summonerexpansion.summonminions.SetRavenlordMinion;

public class RavenlordSummonerSetBonus
extends SetBonusBuff {
    public FloatUpgradeValue featherDamage = new FloatUpgradeValue(0.0f, 0.2f).setBaseValue(50.0f).setUpgradedValue(1.0f, 50.0f);
    public static int FEATHER_SPAWN_RUN_DISTANCE = 2800;

    public void init(ActiveBuff buff, BuffEventSubscriber eventSubscriber) {
        buff.getGndData().setDouble("distanceRan", buff.owner.getDistanceRan());
    }

    public void serverTick(ActiveBuff buff) {
        double distanceRanSinceLastFeatherSpawn;
        double distanceRan;
        super.serverTick(buff);
        Mob owner = buff.owner;
        if (owner.isItemAttacker && (distanceRan = owner.getDistanceRan()) - (distanceRanSinceLastFeatherSpawn = buff.getGndData().getDouble("distanceRan")) > (double)FEATHER_SPAWN_RUN_DISTANCE) {
            this.summonFeather(buff, (ItemAttackerMob)owner);
            buff.getGndData().setDouble("distanceRan", distanceRan);
        }
    }

    private void summonFeather(ActiveBuff buff, ItemAttackerMob itemAttacker) {
        if (itemAttacker.isServer() && itemAttacker.serverFollowersManager.getFollowerCount("ravenlordminion") < 6.0f) {
            SetRavenlordMinion mob = new SetRavenlordMinion();
            itemAttacker.serverFollowersManager.addFollower("ravenlordminion", (Mob)mob, FollowPosition.LARGE_PYRAMID, "summonedmob", 1.0f, 6, null, false);
            mob.updateDamage(new GameDamage(DamageTypeRegistry.SUMMON, this.featherDamage.getValue(buff.getUpgradeTier()).floatValue()));
            itemAttacker.getLevel().entityManager.addMob((Mob)mob, itemAttacker.x, itemAttacker.y);
        }
    }

    public static float getFinalDamage(Mob mob, float baseDamage) {
        return (((Float)mob.buffManager.getModifier(BuffModifiers.SPEED)).floatValue() - 1.0f) * baseDamage;
    }

    public void addStatTooltips(LinkedList<ItemStatTip> list, ActiveBuff currentValues, ActiveBuff lastValues) {
        super.addStatTooltips(list, currentValues, lastValues);
        currentValues.getModifierTooltipsBuilder(true, true).addLastValues((ModifierContainer)lastValues).buildToStatList(list);
        float damage = this.featherDamage.getValue(currentValues.getUpgradeTier()).floatValue();
        if (currentValues.owner != null) {
            damage = RavenlordSummonerSetBonus.getFinalDamage(currentValues.owner, damage) * GameDamage.getDamageModifier((Attacker)currentValues.owner, (DamageType)DamageTypeRegistry.SUMMON);
        }
        DoubleItemStatTip ravenDamageTip = new DoubleItemStatTip(damage, 0){

            public GameMessage toMessage(Color betterColor, Color worseColor, Color neutralColor, boolean showDifference) {
                return new GameMessageBuilder().append((GameMessage)new LocalMessage("itemtooltip", "ravenlordsummonsettip")).append("\n").append((GameMessage)new LocalMessage("itemtooltip", "ravenlordsummonsettip2", "damage", this.getReplaceValue(betterColor, worseColor, showDifference)));
            }
        };
        if (lastValues != null) {
            float compareDamage = this.featherDamage.getValue(lastValues.getUpgradeTier()).floatValue();
            if (lastValues.owner != null) {
                compareDamage = RavenlordSummonerSetBonus.getFinalDamage(lastValues.owner, compareDamage) * GameDamage.getDamageModifier((Attacker)currentValues.owner, (DamageType)DamageTypeRegistry.SUMMON);
            }
            ravenDamageTip.setCompareValue((double)compareDamage);
        }
        list.add((ItemStatTip)ravenDamageTip);
    }
}

