/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonarmorsetbonus;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.GameMessageBuilder;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.modifiers.ModifierContainer;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobWasKilledEvent;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.armorBuffs.setBonusBuffs.SetBonusBuff;
import necesse.entity.mobs.gameDamageType.DamageType;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.AttackingFollowingMob;
import necesse.inventory.item.DoubleItemStatTip;
import necesse.inventory.item.ItemStatTip;
import necesse.inventory.item.toolItem.summonToolItem.SummonToolItem;
import necesse.inventory.item.upgradeUtils.FloatUpgradeValue;
import necesse.inventory.item.upgradeUtils.IntUpgradeValue;
import necesse.level.maps.Level;

public class PharaohsMaskSetBonus
extends SetBonusBuff {
    public IntUpgradeValue armorPen = new IntUpgradeValue().setBaseValue(5).setUpgradedValue(1.0f, 10).setUpgradedValue(10.0f, 20);
    public IntUpgradeValue maxLocustCount = new IntUpgradeValue().setBaseValue(2).setUpgradedValue(1.0f, 4).setUpgradedValue(10.0f, 10);
    public FloatUpgradeValue locustDamage = new FloatUpgradeValue(0.0f, 0.2f).setBaseValue(28.0f).setUpgradedValue(1.0f, 50.0f);
    public int locustCooldown;

    public void init(ActiveBuff buff, BuffEventSubscriber eventSubscriber) {
        this.locustCooldown = 30;
        buff.setModifier(BuffModifiers.ARMOR_PEN_FLAT, (Object)this.armorPen.getValue(buff.getUpgradeTier()));
    }

    public void serverTick(ActiveBuff buff) {
        super.serverTick(buff);
        if (this.locustCooldown < 30) {
            ++this.locustCooldown;
        }
    }

    public void onHasKilledTarget(ActiveBuff buff, MobWasKilledEvent event) {
        float count;
        ItemAttackerMob attackerMob = (ItemAttackerMob)buff.owner;
        if (buff.owner.isItemAttacker && (count = attackerMob.serverFollowersManager.getFollowerCount("locustminion")) < (float)this.maxLocustCount.getValue(buff.getUpgradeTier()).intValue() && this.locustCooldown >= 30) {
            GameDamage explosionDamage = new GameDamage(DamageTypeRegistry.SUMMON, this.locustDamage.getValue(buff.getUpgradeTier()).floatValue());
            AttackingFollowingMob locust = (AttackingFollowingMob)MobRegistry.getMob((String)"locustminion", (Level)attackerMob.getLevel());
            attackerMob.serverFollowersManager.addFollower("locustminion", (Mob)locust, FollowPosition.WALK_CLOSE, "summonedlocust", 1.0f, 10, null, false);
            Point2D.Float spawnPoint = SummonToolItem.findSpawnLocation((Mob)locust, (Level)attackerMob.getLevel(), (float)attackerMob.x, (float)attackerMob.y);
            locust.updateDamage(explosionDamage);
            attackerMob.getLevel().entityManager.addMob((Mob)locust, spawnPoint.x, spawnPoint.y);
            this.locustCooldown = 0;
        }
    }

    public void addStatTooltips(LinkedList<ItemStatTip> list, final ActiveBuff currentValues, ActiveBuff lastValues) {
        super.addStatTooltips(list, currentValues, lastValues);
        currentValues.getModifierTooltipsBuilder(true, true).addLastValues((ModifierContainer)lastValues).buildToStatList(list);
        float damage = this.locustDamage.getValue(currentValues.getUpgradeTier()).floatValue();
        if (currentValues.owner != null) {
            damage *= GameDamage.getDamageModifier((Attacker)currentValues.owner, (DamageType)DamageTypeRegistry.SUMMON);
        }
        DoubleItemStatTip minionDamageTip = new DoubleItemStatTip(damage, 0){

            public GameMessage toMessage(Color betterColor, Color worseColor, Color neutralColor, boolean showDifference) {
                return new GameMessageBuilder().append(Localization.translate((String)"itemtooltip", (String)"pharaohsmasksettip", (String)"amount", (Object)PharaohsMaskSetBonus.this.maxLocustCount.getValue(currentValues.getUpgradeTier()))).append("\n").append((GameMessage)new LocalMessage("itemtooltip", "pharaohsmasksettip2", "damage", this.getReplaceValue(betterColor, worseColor, showDifference)));
            }
        };
        if (lastValues != null) {
            float compareDamage = this.locustDamage.getValue(lastValues.getUpgradeTier()).floatValue();
            if (lastValues.owner != null) {
                compareDamage *= GameDamage.getDamageModifier((Attacker)currentValues.owner, (DamageType)DamageTypeRegistry.SUMMON);
            }
            minionDamageTip.setCompareValue((double)compareDamage);
        }
        list.add((ItemStatTip)minionDamageTip);
    }
}

