/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonarmorsetbonus;

import java.awt.Color;
import java.util.LinkedList;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.GameMessageBuilder;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.modifiers.ModifierContainer;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobWasHitEvent;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.armorBuffs.setBonusBuffs.SetBonusBuff;
import necesse.entity.mobs.gameDamageType.DamageType;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.inventory.item.DoubleItemStatTip;
import necesse.inventory.item.ItemStatTip;
import necesse.inventory.item.upgradeUtils.FloatUpgradeValue;
import necesse.inventory.item.upgradeUtils.IntUpgradeValue;
import summonerexpansion.summonminions.SetChefMinion;

public class ChefSummonerHatSetBonus
extends SetBonusBuff {
    public FloatUpgradeValue chefDamage = new FloatUpgradeValue(0.0f, 0.2f).setBaseValue(50.0f).setUpgradedValue(1.0f, 50.0f);
    public IntUpgradeValue maxSummons = new IntUpgradeValue().setBaseValue(1).setUpgradedValue(1.0f, 2);
    public IntUpgradeValue maxFood = new IntUpgradeValue().setBaseValue(1).setUpgradedValue(1.0f, 1).setUpgradedValue(10.0f, 2);
    public IntUpgradeValue minionDuration = new IntUpgradeValue().setBaseValue(300).setUpgradedValue(1.0f, 400).setUpgradedValue(10.0f, 1200);

    public void init(ActiveBuff buff, BuffEventSubscriber eventSubscriber) {
        buff.setModifier(BuffModifiers.MAX_SUMMONS, (Object)this.maxSummons.getValue(buff.getUpgradeTier()));
        buff.setModifier(BuffModifiers.MAX_FOOD_BUFFS, (Object)this.maxFood.getValue(buff.getUpgradeTier()));
    }

    public void onWasHit(ActiveBuff buff, MobWasHitEvent event) {
        super.onWasHit(buff, event);
        ItemAttackerMob attackerMob = (ItemAttackerMob)buff.owner;
        if (attackerMob.isServer() && attackerMob.serverFollowersManager.getFollowerCount("chefminion") < 3.0f) {
            SetChefMinion mob = new SetChefMinion();
            attackerMob.serverFollowersManager.addFollower("chefminion", (Mob)mob, FollowPosition.LARGE_PYRAMID, "summonedmob", 1.0f, 3, null, false);
            mob.updateDamage(new GameDamage(DamageTypeRegistry.SUMMON, this.chefDamage.getValue(buff.getUpgradeTier()).floatValue()));
            mob.lifeTime = this.minionDuration.getValue(buff.getUpgradeTier());
            attackerMob.getLevel().entityManager.addMob((Mob)mob, attackerMob.x, attackerMob.y);
        }
    }

    public void addStatTooltips(LinkedList<ItemStatTip> list, ActiveBuff currentValues, ActiveBuff lastValues) {
        super.addStatTooltips(list, currentValues, lastValues);
        currentValues.getModifierTooltipsBuilder(true, true).addLastValues((ModifierContainer)lastValues).buildToStatList(list);
        float damage = this.chefDamage.getValue(currentValues.getUpgradeTier()).floatValue();
        if (currentValues.owner != null) {
            damage *= GameDamage.getDamageModifier((Attacker)currentValues.owner, (DamageType)DamageTypeRegistry.SUMMON);
        }
        DoubleItemStatTip minionDamageTip = new DoubleItemStatTip(damage, 0){

            public GameMessage toMessage(Color betterColor, Color worseColor, Color neutralColor, boolean showDifference) {
                return new GameMessageBuilder().append((GameMessage)new LocalMessage("itemtooltip", "chefsummonerhattip")).append("\n").append((GameMessage)new LocalMessage("itemtooltip", "chefsummonerhattip2", "damage", this.getReplaceValue(betterColor, worseColor, showDifference)));
            }
        };
        if (lastValues != null) {
            float compareDamage = this.chefDamage.getValue(lastValues.getUpgradeTier()).floatValue();
            if (lastValues.owner != null) {
                compareDamage *= GameDamage.getDamageModifier((Attacker)currentValues.owner, (DamageType)DamageTypeRegistry.SUMMON);
            }
            minionDamageTip.setCompareValue((double)compareDamage);
        }
        list.add((ItemStatTip)minionDamageTip);
    }
}

