/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonarmorsetbonus;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.GameMessageBuilder;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.modifiers.ModifierContainer;
import necesse.engine.network.Packet;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffAbility;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.armorBuffs.setBonusBuffs.SetBonusBuff;
import necesse.entity.mobs.gameDamageType.DamageType;
import necesse.entity.mobs.itemAttacker.CheckSlotType;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.item.DoubleItemStatTip;
import necesse.inventory.item.ItemStatTip;
import necesse.inventory.item.toolItem.summonToolItem.SummonToolItem;
import necesse.inventory.item.upgradeUtils.FloatUpgradeValue;
import necesse.inventory.item.upgradeUtils.IntUpgradeValue;
import necesse.level.maps.Level;
import summonerexpansion.summonminions.SetArcanicPylonSentry;

public class ArcanicSummonerSetBonus
extends SetBonusBuff
implements BuffAbility {
    public FloatUpgradeValue pylonDamage = new FloatUpgradeValue(0.0f, 0.2f).setBaseValue(40.0f).setUpgradedValue(1.0f, 40.0f);
    public FloatUpgradeValue summonDamage = new FloatUpgradeValue().setBaseValue(0.2f).setUpgradedValue(1.0f, 0.2f).setUpgradedValue(10.0f, 1.0f);
    public IntUpgradeValue minionDuration = new IntUpgradeValue().setBaseValue(300).setUpgradedValue(1.0f, 400).setUpgradedValue(10.0f, 1200);

    public void init(ActiveBuff buff, BuffEventSubscriber eventSubscriber) {
        if (buff.owner.buffManager.hasBuff(BuffRegistry.Debuffs.MANA_EXHAUSTION)) {
            buff.setModifier(BuffModifiers.SUMMON_DAMAGE, (Object)this.summonDamage.getValue(buff.getUpgradeTier()));
        }
    }

    public void runAbility(PlayerMob player, ActiveBuff buff, Packet content) {
        float cooldown = 75.0f;
        if (player.isServer()) {
            GameDamage damage = new GameDamage(DamageTypeRegistry.SUMMON, this.pylonDamage.getValue(buff.getUpgradeTier()).floatValue());
            ItemAttackerMob attackerMob = (ItemAttackerMob)buff.owner;
            SetArcanicPylonSentry mob = new SetArcanicPylonSentry();
            attackerMob.serverFollowersManager.addFollower("arcanicsummonbuff", (Mob)mob, FollowPosition.WALK_CLOSE, "summonedmob", 1.0f, 1, null, false);
            Point2D.Float spawnPoint = SummonToolItem.findSpawnLocation((Mob)mob, (Level)buff.owner.getLevel(), (float)attackerMob.x, (float)attackerMob.y);
            mob.updateDamage(damage);
            mob.lifeTime = this.minionDuration.getValue(buff.getUpgradeTier());
            mob.setRemoveWhenNotInInventory(ItemRegistry.getItem((String)"arcanicsummonhelmet"), CheckSlotType.HELMET);
            attackerMob.getLevel().entityManager.addMob((Mob)mob, spawnPoint.x, spawnPoint.y);
        }
        player.buffManager.addBuff(new ActiveBuff(BuffRegistry.getBuff((String)"arcanicsummoncooldown"), (Mob)player, cooldown, null), false);
    }

    public boolean canRunAbility(PlayerMob player, ActiveBuff buff, Packet content) {
        return !buff.owner.buffManager.hasBuff(BuffRegistry.getBuff((String)"arcanicsummoncooldown"));
    }

    public ListGameTooltips getTooltip(ActiveBuff ab, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getTooltip(ab, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"arcanicsummonsettip"));
        return tooltips;
    }

    public void addStatTooltips(LinkedList<ItemStatTip> list, ActiveBuff currentValues, ActiveBuff lastValues) {
        super.addStatTooltips(list, currentValues, lastValues);
        currentValues.getModifierTooltipsBuilder(true, true).addLastValues((ModifierContainer)lastValues).buildToStatList(list);
        float damage = this.pylonDamage.getValue(currentValues.getUpgradeTier()).floatValue();
        if (currentValues.owner != null) {
            damage *= GameDamage.getDamageModifier((Attacker)currentValues.owner, (DamageType)DamageTypeRegistry.SUMMON);
        }
        DoubleItemStatTip minionDamageTip = new DoubleItemStatTip(damage, 0){

            public GameMessage toMessage(Color betterColor, Color worseColor, Color neutralColor, boolean showDifference) {
                return new GameMessageBuilder().append((GameMessage)new LocalMessage("itemtooltip", "arcanicsummonsettip2", "damage", this.getReplaceValue(betterColor, worseColor, showDifference)));
            }
        };
        if (lastValues != null) {
            float compareDamage = this.pylonDamage.getValue(lastValues.getUpgradeTier()).floatValue();
            if (lastValues.owner != null) {
                compareDamage *= GameDamage.getDamageModifier((Attacker)currentValues.owner, (DamageType)DamageTypeRegistry.SUMMON);
            }
            minionDamageTip.setCompareValue((double)compareDamage);
        }
        list.add((ItemStatTip)minionDamageTip);
    }
}

