/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonarmorsetbonus;

import java.awt.Color;
import java.awt.Point;
import java.util.LinkedList;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.GameMessageBuilder;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.modifiers.ModifierContainer;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobWasHitEvent;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffManager;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.armorBuffs.setBonusBuffs.SetBonusBuff;
import necesse.entity.mobs.gameDamageType.DamageType;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.AttackingFollowingMob;
import necesse.inventory.item.DoubleItemStatTip;
import necesse.inventory.item.ItemStatTip;
import necesse.inventory.item.upgradeUtils.FloatUpgradeValue;
import necesse.inventory.item.upgradeUtils.IntUpgradeValue;
import necesse.level.maps.Level;

public class AgedSummonerSetBonus
extends SetBonusBuff {
    public IntUpgradeValue maxResilience = new IntUpgradeValue().setBaseValue(30).setUpgradedValue(1.0f, 30);
    public FloatUpgradeValue resilienceGain = new FloatUpgradeValue().setBaseValue(0.2f).setUpgradedValue(1.0f, 0.2f);
    public FloatUpgradeValue summonSpeed = new FloatUpgradeValue(0.0f, 0.2f).setBaseValue(0.2f).setUpgradedValue(1.0f, 0.2f);
    public FloatUpgradeValue agedDamage = new FloatUpgradeValue(0.0f, 0.2f).setBaseValue(25.0f).setUpgradedValue(1.0f, 25.0f);

    public void init(ActiveBuff buff, BuffEventSubscriber eventSubscriber) {
        buff.setModifier(BuffModifiers.MAX_RESILIENCE_FLAT, (Object)this.maxResilience.getValue(buff.getUpgradeTier()));
        buff.setModifier(BuffModifiers.RESILIENCE_GAIN, (Object)this.resilienceGain.getValue(buff.getUpgradeTier()));
        buff.setModifier(BuffModifiers.SUMMONS_SPEED, (Object)this.summonSpeed.getValue(buff.getUpgradeTier()));
    }

    public void clientTick(ActiveBuff buff) {
        this.updateModifiers(buff);
    }

    public void serverTick(ActiveBuff buff) {
        this.updateModifiers(buff);
    }

    private void updateModifiers(ActiveBuff buff) {
        boolean fullHealth;
        boolean bl = fullHealth = buff.owner.getHealthPercent() == 1.0f;
        if (buff.owner.isItemAttacker && fullHealth) {
            ItemAttackerMob attackerMob = (ItemAttackerMob)buff.owner;
            float count = attackerMob.serverFollowersManager.getFollowerCount("agedchampionminion");
            if (count <= 0.0f) {
                GameDamage damage = new GameDamage(DamageTypeRegistry.SUMMON, this.agedDamage.getValue(buff.getUpgradeTier()).floatValue());
                Level level = buff.owner.getLevel();
                AttackingFollowingMob mob = (AttackingFollowingMob)MobRegistry.getMob((String)"agedchampionminion", (Level)level);
                attackerMob.serverFollowersManager.addFollower("agedchampionminion", (Mob)mob, FollowPosition.WALK_CLOSE, "summonedagedchampionminionbuff", 1.0f, 1, null, false);
                mob.updateDamage(damage);
                Point spawnPoint = new Point(attackerMob.getX() + GameRandom.globalRandom.getIntBetween(-5, 5), attackerMob.getY() + GameRandom.globalRandom.getIntBetween(-5, 5));
                level.entityManager.addMob((Mob)mob, (float)spawnPoint.x, (float)spawnPoint.y);
            }
        } else {
            BuffManager buffManager = buff.owner.buffManager;
            if (buff.owner.isServer() && buffManager.hasBuff("summonedagedchampionminionbuff")) {
                buffManager.removeBuff("summonedagedchampionminionbuff", true);
            }
        }
    }

    public void onWasHit(ActiveBuff buff, MobWasHitEvent event) {
        super.onWasHit(buff, event);
        if (buff.owner.buffManager.hasBuff(BuffRegistry.PERFECT_BLOCK)) {
            buff.owner.buffManager.addBuff(new ActiveBuff(BuffRegistry.AGED_CHAMPION_PROWESS, buff.owner, 5000, null), false);
        }
    }

    public void onRemoved(ActiveBuff buff) {
        super.onRemoved(buff);
        BuffManager buffManager = buff.owner.buffManager;
        if (buff.owner.isServer() && buffManager.hasBuff("summonedagedchampionminionbuff")) {
            buffManager.removeBuff("summonedagedchampionminionbuff", true);
        }
    }

    public void addStatTooltips(LinkedList<ItemStatTip> list, ActiveBuff currentValues, ActiveBuff lastValues) {
        super.addStatTooltips(list, currentValues, lastValues);
        currentValues.getModifierTooltipsBuilder(true, true).addLastValues((ModifierContainer)lastValues).buildToStatList(list);
        float damage = this.agedDamage.getValue(currentValues.getUpgradeTier()).floatValue();
        if (currentValues.owner != null) {
            damage *= GameDamage.getDamageModifier((Attacker)currentValues.owner, (DamageType)DamageTypeRegistry.SUMMON);
        }
        DoubleItemStatTip minionDamageTip = new DoubleItemStatTip(damage, 0){

            public GameMessage toMessage(Color betterColor, Color worseColor, Color neutralColor, boolean showDifference) {
                return new GameMessageBuilder().append((GameMessage)new LocalMessage("itemtooltip", "agedsummonersettip")).append("\n").append((GameMessage)new LocalMessage("itemtooltip", "agedsummonersettip2", "damage", this.getReplaceValue(betterColor, worseColor, showDifference)));
            }
        };
        if (lastValues != null) {
            float compareDamage = this.agedDamage.getValue(lastValues.getUpgradeTier()).floatValue();
            if (lastValues.owner != null) {
                compareDamage *= GameDamage.getDamageModifier((Attacker)currentValues.owner, (DamageType)DamageTypeRegistry.SUMMON);
            }
            minionDamageTip.setCompareValue((double)compareDamage);
        }
        list.add((ItemStatTip)minionDamageTip);
    }
}

