/*
 * Decompiled with CFR 0.152.
 */
package dpsmod.patches;

import dpsmod.DPSMod;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.util.GameUtils;
import necesse.entity.mobs.Mob;
import net.bytebuddy.asm.Advice;

@ModMethodPatch(target=Mob.class, name="clientTick", arguments={})
public class ClientTickPatch {
    @Advice.OnMethodExit
    static void onExit(@Advice.This Mob mob) {
        if (!mob.isPlayer) {
            return;
        }
        long currentTime = mob.getWorldEntity().getTime();
        DPSMod.playerDPSTracker.tick(currentTime);
        if (mob.getLevel().tickManager().isFirstGameTickInSecond() && DPSMod.playerDPSTracker.isLastHitBeforeReset(currentTime)) {
            int dps = DPSMod.playerDPSTracker.getDPS(currentTime);
            String text = GameUtils.formatNumber((double)dps) + " dps";
            DPSMod.staticMessage.setMessage(text);
            DPSMod.formLabel.setText((GameMessage)DPSMod.staticMessage);
        }
    }
}

