/*
 * Decompiled with CFR 0.152.
 */
package chaoticnpc.npcs.combat;

import chaoticnpc.autonpc.BaseNPC;
import java.util.Collections;
import java.util.List;
import necesse.engine.network.server.ServerClient;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.HumanAI;
import necesse.entity.mobs.ai.behaviourTree.util.AIMover;
import necesse.entity.mobs.friendly.human.HumanMob;
import necesse.gfx.drawOptions.human.HumanDrawOptions;
import necesse.inventory.InventoryItem;
import necesse.inventory.lootTable.LootTable;

public class KnightMob
extends BaseNPC {
    public static String npcID = "knight";

    public KnightMob() {
        super(1500, 1000, "knight", 400, 400);
        this.talkOptions = 6;
        this.setSpeed(40.0f);
        this.canJoinAdventureParties = true;
        this.jobTypeHandler.getPriority((String)"crafting").disabledBySettler = true;
        this.jobTypeHandler.getPriority((String)"forestry").disabledBySettler = true;
        this.jobTypeHandler.getPriority((String)"farming").disabledBySettler = true;
        this.equipmentInventory.setItem(1, new InventoryItem("ironchestplate"));
        this.equipmentInventory.setItem(2, new InventoryItem("ironboots"));
        this.equipmentInventory.setItem(6, new InventoryItem("quartzgreatsword"));
    }

    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new HumanAI(640, true, true, 25000), new AIMover(HumanMob.humanPathIterations));
    }

    public float getArmor() {
        return super.getArmor() * 1.5f;
    }

    public float getRegenFlat() {
        return super.getRegenFlat() * 2.0f;
    }

    @Override
    public LootTable getLootTable() {
        return super.getLootTable();
    }

    public void setDefaultArmor(HumanDrawOptions drawOptions) {
        drawOptions.helmet(new InventoryItem("spideritehelmet"));
        drawOptions.chestplate(new InventoryItem("ironchestplate"));
        drawOptions.boots(new InventoryItem("ironboots"));
    }

    @Override
    public List<InventoryItem> getRecruitItems(ServerClient client) {
        GameRandom random = new GameRandom((long)this.getSettlerSeed() * 29L);
        return Collections.singletonList(new InventoryItem("coin", random.getIntBetween(1000, 1500)));
    }
}

