/*
 * Decompiled with CFR 0.152.
 */
package chaoticnpc.item;

import java.awt.Point;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.network.Packet;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.network.packet.PacketChatMessage;
import necesse.engine.registries.MobRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.GameResources;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.gfx.gameTooltips.StringTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.placeableItem.consumableItem.ConsumableItem;
import necesse.level.maps.Level;
import necesse.level.maps.regionSystem.RegionPositionGetter;

public class MakeSummon
extends ConsumableItem {
    private final String settlerStringID;
    public boolean IsSingleUse;

    public MakeSummon(int stackSize, boolean singleUse, String settlerStringID) {
        super(stackSize, singleUse);
        this.IsSingleUse = singleUse;
        this.itemCooldownTime.setBaseValue(2000);
        this.setItemCategory(new String[]{"consumable", "bossitems"});
        this.dropsAsMatDeathPenalty = false;
        this.keyWords.add("npc");
        this.keyWords.add("chaotic");
        this.keyWords.add("chaoticnpcs");
        this.keyWords.add("settler");
        this.keyWords.add("summon");
        this.rarity = Item.Rarity.UNCOMMON;
        this.incinerationTimeMillis = 30000;
        this.settlerStringID = settlerStringID;
    }

    public boolean getConstantUse(InventoryItem item) {
        return false;
    }

    public InventoryItem onPlace(Level level, int x, int y, PlayerMob player, int seed, InventoryItem item, GNDItemMap mapContent) {
        if (level.isServer()) {
            Mob mob = MobRegistry.getMob((String)this.settlerStringID, (Level)level);
            Point spawnPoint = this.findSpawnLocation(level, mob, player.getX() / 32, player.getY() / 32, 1);
            level.entityManager.addMob(mob, (float)spawnPoint.x, (float)spawnPoint.y);
            level.getServer().network.sendToClientsWithEntity((Packet)new PacketChatMessage((GameMessage)new LocalMessage("misc", "bosssummon", "name", mob.getLocalization())), (RegionPositionGetter)mob);
        }
        if (level.isClient()) {
            SoundManager.playSound((GameSound)GameResources.pop, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)player).pitch(0.8f));
        }
        if (this.IsSingleUse) {
            item.setAmount(item.getAmount() - 1);
        }
        return item;
    }

    protected Point findSpawnLocation(Level level, Mob mob, int tileX, int tileY, int maxTileRange) {
        ArrayList<Point> possibleSpawns = new ArrayList<Point>();
        for (int x = tileX - maxTileRange; x <= tileX + maxTileRange; ++x) {
            for (int y = tileY - maxTileRange; y <= tileY + maxTileRange; ++y) {
                int posY;
                int posX;
                if (x == tileX && y == tileY || mob.collidesWith(level, posX = x * 32 + 16, posY = y * 32 + 16)) continue;
                possibleSpawns.add(new Point(posX, posY));
            }
        }
        if (!possibleSpawns.isEmpty()) {
            return (Point)possibleSpawns.get(GameRandom.globalRandom.nextInt(possibleSpawns.size()));
        }
        return new Point(tileX * 32 + 16, tileY * 32 + 16);
    }

    public String canPlace(Level level, int x, int y, PlayerMob player, Line2D playerPositionLine, InventoryItem item, GNDItemMap mapContent) {
        return null;
    }

    public ListGameTooltips getTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getTooltips(item, perspective, blackboard);
        tooltips.add((Object)new StringTooltips(Localization.translate((String)"itemtooltip", (String)"spawnmob", (String)"mob", (String)MobRegistry.getDisplayName((int)MobRegistry.getMobID((String)this.settlerStringID)))));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)(this.settlerStringID + "tooltip")));
        if (this.IsSingleUse) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"singleuse"));
        } else {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"infiniteuse"));
        }
        return tooltips;
    }
}

