/*
 * Decompiled with CFR 0.152.
 */
package chaoticnpc.item;

import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.StaticMessage;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.matItem.MatItem;

public class LockedItem
extends MatItem {
    public LockedItem() {
        super(1, Item.Rarity.COMMON, new String[0]);
    }

    public GameMessage getLocalization(InventoryItem item) {
        return new StaticMessage(item.getGndData().getString("itemLangName", "ERROR"));
    }

    public ListGameTooltips getTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getTooltips(item, perspective, blackboard);
        GNDItemMap gndItemMap = item.getGndData();
        String condition = gndItemMap.getString("unlockWithKill", null);
        if (condition != null) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"killbossfirst"));
            tooltips.add("\u00a76" + Localization.translate((String)"mob", (String)condition));
        }
        if ((condition = gndItemMap.getString("unlockGettingFirst", null)) != null) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"obtainitemfirst"));
            String lang = item.getGndData().getString("itemLangName", "ERROR");
            tooltips.add("\u00a76" + lang);
        }
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"npctakeanote"));
        return tooltips;
    }

    protected void loadItemTextures() {
        this.itemTexture = GameTexture.fromFile((String)"items/lockeditem");
    }
}

