/*
 * Decompiled with CFR 0.152.
 */
package chaoticnpc.autonpc;

import chaoticnpc.LangUtils;
import chaoticnpc.autonpc.BaseNPC;
import chaoticnpc.autonpc.CustomShopItem;
import java.util.ArrayList;
import necesse.engine.localization.message.GameMessage;
import necesse.entity.mobs.friendly.human.humanShop.SellingShopItem;
import necesse.inventory.InventoryItem;

public class ShopNPC
extends BaseNPC {
    public ArrayList<CustomShopItem> itemsList = new ArrayList();

    public ShopNPC(int nonSettlerHealth, int settlerHealth, String settlerStringID) {
        super(nonSettlerHealth, settlerHealth, settlerStringID);
        this.setShopContent();
        this.loadCustomShop();
    }

    public ShopNPC(int nonSettlerHealth, int settlerHealth, String settlerStringID, int attackCooldown, int attackAnimTime) {
        super(nonSettlerHealth, settlerHealth, settlerStringID, attackCooldown, attackAnimTime);
        this.setShopContent();
        this.loadCustomShop();
    }

    public void setShopContent() {
    }

    public void loadCustomShop() {
        for (CustomShopItem item : this.itemsList) {
            switch (item.condition) {
                case ALWAYS: {
                    this.shop.addSellingItem(item.itemStringID, new SellingShopItem()).setStaticPriceBasedOnHappiness(item.minPrice, item.maxPrice, item.range);
                    break;
                }
                case GET_FIRST: {
                    this.shop.addSellingItem(item.itemStringID, new SellingShopItem()).setItem((random, client, mob) -> {
                        if (client.characterStats().items_obtained.isStatItemObtained(item.itemStringID)) {
                            return new InventoryItem(item.itemStringID);
                        }
                        return this.addLockItem(item);
                    }).setStaticPriceBasedOnHappiness(item.minPrice, item.maxPrice, item.range);
                    break;
                }
                case KILL_FIRST: {
                    this.shop.addSellingItem(item.itemStringID, new SellingShopItem()).setItem((random, client, mob) -> {
                        if (client.characterStats().mob_kills.getKills(item.conditionID) > 0) {
                            return new InventoryItem(item.itemStringID);
                        }
                        return this.addLockItem(item);
                    }).setStaticPriceBasedOnHappiness(item.minPrice, item.maxPrice, item.range);
                    break;
                }
            }
        }
    }

    public InventoryItem addLockItem(CustomShopItem item) {
        InventoryItem inventoryItem = new InventoryItem("lockeditem");
        inventoryItem = this.getItemLang(inventoryItem, item);
        switch (item.condition) {
            case KILL_FIRST: {
                inventoryItem.getGndData().setString("unlockWithKill", item.conditionID);
                break;
            }
            case GET_FIRST: {
                inventoryItem.getGndData().setString("unlockGettingFirst", item.conditionID);
            }
        }
        return inventoryItem;
    }

    public InventoryItem getItemLang(InventoryItem inventoryItem, CustomShopItem item) {
        LangUtils langUtils = new LangUtils();
        GameMessage message = langUtils.getItemLang(new InventoryItem(item.itemStringID));
        inventoryItem.getGndData().setString("itemLangName", message.translate());
        return inventoryItem;
    }
}

